/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.component.PottedFlower;

public class FramedFlowerPotBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<Block> FLOWER_BLOCK = new ModelProperty();
    private Block flowerBlock = Blocks.AIR;

    public FramedFlowerPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_FLOWER_POT.value(), pos, state);
    }

    public void setFlowerBlock(Block flowerBlock) {
        if (flowerBlock != this.flowerBlock) {
            this.flowerBlock = flowerBlock;
            this.setChangedWithoutSignalUpdate();
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean hasFlowerBlock() {
        return this.flowerBlock != Blocks.AIR;
    }

    public Block getFlowerBlock() {
        return this.flowerBlock;
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean dropCamo) {
        super.addAdditionalDrops(drops, dropCamo);
        if (this.flowerBlock != Blocks.AIR) {
            drops.add(new ItemStack((ItemLike)this.flowerBlock));
        }
    }

    @Override
    protected void attachAdditionalModelData(ModelData.Builder builder) {
        builder.with(FLOWER_BLOCK, (Object)this.flowerBlock);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        nbt.putString("flower", BuiltInRegistries.BLOCK.getKey((Object)this.flowerBlock).toString());
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        boolean update;
        Block flower = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("flower")));
        boolean bl = update = flower != this.flowerBlock;
        if (update) {
            this.flowerBlock = flower;
        }
        return super.readFromDataPacket(nbt, lookupProvider) || update;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.putString("flower", BuiltInRegistries.BLOCK.getKey((Object)this.flowerBlock).toString());
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        super.handleUpdateTag(nbt, provider);
        Block flower = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("flower")));
        if (flower != this.flowerBlock) {
            this.flowerBlock = flower;
        }
    }

    @Override
    protected Optional<AuxBlueprintData<?>> collectAuxBlueprintData() {
        return Optional.of(new PottedFlower(this.flowerBlock));
    }

    @Override
    protected void applyAuxDataFromBlueprint(AuxBlueprintData<?> auxData) {
        PottedFlower flower;
        if (auxData instanceof PottedFlower && !(flower = (PottedFlower)auxData).isEmpty()) {
            this.flowerBlock = flower.flower();
        }
    }

    @Override
    protected void collectMiscComponents(DataComponentMap.Builder builder) {
        if (this.hasFlowerBlock()) {
            builder.set(FBContent.DC_TYPE_POTTED_FLOWER, (Object)new PottedFlower(this.flowerBlock));
        }
    }

    @Override
    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
        PottedFlower flower = (PottedFlower)input.getOrDefault(FBContent.DC_TYPE_POTTED_FLOWER, (Object)PottedFlower.EMPTY);
        if (!flower.isEmpty()) {
            this.flowerBlock = flower.flower();
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putString("flower", BuiltInRegistries.BLOCK.getKey((Object)this.flowerBlock).toString());
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.flowerBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)nbt.getString("flower")));
    }
}

