/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.ICollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.component.CollapsibleCopycatBlockData;

public class FramedCollapsibleCopycatBlockEntity
extends FramedBlockEntity
implements ICollapsibleCopycatBlockEntity {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Direction[] HORIZONTAL_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().toArray(Direction[]::new);
    private static final int MAX_OFFSET_BEACON_OCCLUSION = 5;
    public static final ModelProperty<Integer> OFFSETS = new ModelProperty();
    private int packedOffsets = 0;
    private boolean occludesBeacon = true;

    public FramedCollapsibleCopycatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_COLLAPSIBLE_COPYCAT_BLOCK.value(), pos, state);
    }

    public void handleDeform(Player player) {
        HitResult hit = player.pick(10.0, 1.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction faceHit = blockHit.getDirection();
        boolean sneak = player.isShiftKeyDown();
        boolean changed = false;
        int offset = this.getFaceOffset(faceHit);
        if (sneak && offset > 0) {
            this.setFaceOffset(faceHit, offset - 1);
            changed = true;
        } else if (!sneak && offset < 15 - this.getFaceOffset(faceHit.getOpposite())) {
            this.setFaceOffset(faceHit, offset + 1);
            changed = true;
        }
        if (changed) {
            this.updateBeaconOcclusion();
            if (!this.updateFaceSolidity()) {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            this.setChangedWithoutSignalUpdate();
        }
    }

    private void setFaceOffset(Direction side, int offset) {
        int idx = side.ordinal() * 4;
        int mask = 15 << idx;
        this.packedOffsets = this.packedOffsets & ~mask | offset << idx;
    }

    public int getFaceOffset(Direction side) {
        return (byte)(this.packedOffsets >> side.ordinal() * 4 & 0xF);
    }

    @Override
    public int getFaceOffset(BlockState state, Direction side) {
        return this.getFaceOffset(side);
    }

    @Override
    public int getPackedOffsets(BlockState state) {
        return this.packedOffsets;
    }

    public boolean doesOccludeBeaconBeam() {
        return this.occludesBeacon;
    }

    public boolean updateFaceSolidity() {
        BlockState state = this.getBlockState();
        int solid = FramedCollapsibleCopycatBlockEntity.computeSolidFaces(this.packedOffsets);
        if ((Integer)state.getValue((Property)PropertyHolder.SOLID_FACES) != solid) {
            this.level().setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)PropertyHolder.SOLID_FACES, (Comparable)Integer.valueOf(solid)));
            return true;
        }
        return false;
    }

    private void updateBeaconOcclusion() {
        this.occludesBeacon = true;
        for (Direction face : HORIZONTAL_DIRECTIONS) {
            if (this.getFaceOffset(face) <= 5) continue;
            this.occludesBeacon = false;
            break;
        }
    }

    @Override
    protected void attachAdditionalModelData(ModelData.Builder builder) {
        builder.with(OFFSETS, (Object)this.getPackedOffsets(this.getBlockState()));
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        nbt.putInt("offsets", this.packedOffsets);
        nbt.putBoolean("occludesBeacon", this.occludesBeacon);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        boolean needUpdate = super.readFromDataPacket(nbt, lookupProvider);
        int packed = nbt.getInt("offsets");
        if (packed != this.packedOffsets) {
            this.packedOffsets = packed;
            needUpdate = true;
            this.updateCulling(true, false);
        }
        this.occludesBeacon = nbt.getBoolean("occludesBeacon");
        return needUpdate;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.putInt("offsets", this.packedOffsets);
        nbt.putBoolean("occludesBeacon", this.occludesBeacon);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        this.packedOffsets = nbt.getInt("offsets");
        this.occludesBeacon = nbt.getBoolean("occludesBeacon");
        super.handleUpdateTag(nbt, provider);
    }

    @Override
    protected Optional<AuxBlueprintData<?>> collectAuxBlueprintData() {
        return Optional.of(new CollapsibleCopycatBlockData(this.packedOffsets));
    }

    @Override
    protected void applyAuxDataFromBlueprint(AuxBlueprintData<?> auxData) {
        if (auxData instanceof CollapsibleCopycatBlockData) {
            CollapsibleCopycatBlockData blockData = (CollapsibleCopycatBlockData)auxData;
            this.packedOffsets = blockData.offsets();
        }
    }

    @Override
    protected void collectMiscComponents(DataComponentMap.Builder builder) {
        builder.set(FBContent.DC_TYPE_COLLAPSIBLE_COPYCAT_BLOCK_DATA, (Object)new CollapsibleCopycatBlockData(this.packedOffsets));
    }

    @Override
    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
        CollapsibleCopycatBlockData blockData = (CollapsibleCopycatBlockData)input.get(FBContent.DC_TYPE_COLLAPSIBLE_COPYCAT_BLOCK_DATA);
        if (blockData != null) {
            this.packedOffsets = blockData.offsets();
            this.updateFaceSolidity();
            this.updateBeaconOcclusion();
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putInt("offsets", this.packedOffsets);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.packedOffsets = nbt.getInt("offsets");
        this.updateBeaconOcclusion();
    }

    public static byte[] unpackOffsets(int packed) {
        byte[] offsets = new byte[DIRECTIONS.length];
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            offsets[i] = (byte)(packed >> i * 4 & 0xF);
        }
        return offsets;
    }

    public static int computeSolidFaces(int packedOffsets) {
        int solid = 0;
        for (Direction face : DIRECTIONS) {
            if ((packedOffsets >> face.ordinal() * 4 & 0xF) != 0) continue;
            solid |= 1 << face.ordinal();
        }
        return solid;
    }
}

