/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedSlicedStairsSlabBlock
extends FramedStairsBlock
implements IFramedDoubleBlock {
    public FramedSlicedStairsSlabBlock() {
        super(BlockType.FRAMED_SLICED_STAIRS_SLAB);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (state.getValue((Property)HALF) != Half.TOP) {
            return DoubleBlockTopInteractionMode.EITHER;
        }
        return DoubleBlockTopInteractionMode.FIRST;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean top = state.getValue((Property)HALF) == Half.TOP;
        BlockState partTwo = switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.INNER_LEFT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.INNER_RIGHT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.OUTER_LEFT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.OUTER_RIGHT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
        };
        return new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB.value()).defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)partTwo);
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dirTwo;
        Direction dir = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        boolean top = state.getValue((Property)HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo) {
            return SolidityCheck.FIRST;
        }
        if (side == dir && shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return SolidityCheck.BOTH;
        }
        if (side == dir.getCounterClockWise() && shape == StairsShape.INNER_LEFT) {
            return SolidityCheck.BOTH;
        }
        if (side == dir.getClockWise() && shape == StairsShape.INNER_RIGHT) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean top = state.getValue((Property)HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo || !Utils.isY(side) && edge == dirTwo) {
            return CamoGetter.FIRST;
        }
        return switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> {
                if (side == dir && edge == dirTwo.getOpposite()) {
                    yield CamoGetter.SECOND;
                }
                if (side == dirTwo.getOpposite() && edge == dir) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.INNER_LEFT -> {
                if (side == dirTwo.getOpposite() && (edge == dir || edge == dir.getCounterClockWise())) {
                    yield CamoGetter.SECOND;
                }
                if ((side == dir || side == dir.getCounterClockWise()) && edge == dirTwo.getOpposite()) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.INNER_RIGHT -> {
                if (side == dirTwo.getOpposite() && (edge == dir || edge == dir.getClockWise())) {
                    yield CamoGetter.SECOND;
                }
                if ((side == dir || side == dir.getClockWise()) && edge == dirTwo.getOpposite()) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> CamoGetter.NONE;
        };
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

