/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive.button;

import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.interactive.button.FramedLargeButtonBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedButtonBlock
extends ButtonBlock
implements IFramedBlock {
    public static final ButtonStateMerger STATE_MERGER = new ButtonStateMerger();
    private final BlockType type;
    private final float jadeScale;

    protected FramedButtonBlock(BlockType type, BlockSetType blockSet, int pressTime) {
        super(blockSet, pressTime, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f).sound(SoundType.WOOD).noOcclusion());
        this.type = type;
        this.jadeScale = type == BlockType.FRAMED_BUTTON || type == BlockType.FRAMED_STONE_BUTTON ? 2.0f : 1.0f;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = this.handleUse(state, level, pos, player, hand, hit);
        if (result == ItemInteractionResult.FAIL) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return result;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (state.getValue((Property)FACE) != AttachFace.WALL) {
            return this.rotate(state, rot);
        }
        return state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public BlockType getBlockType() {
        return this.type;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.FLOOR);
    }

    @Override
    public Class<? extends Block> getJadeTargetClass() {
        return FramedButtonBlock.class;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.FLOOR);
    }

    @Override
    public float getJadeRenderScale(BlockState state) {
        return this.jadeScale;
    }

    public static FramedButtonBlock wood() {
        return new FramedButtonBlock(BlockType.FRAMED_BUTTON, BlockSetType.OAK, 30);
    }

    public static FramedButtonBlock stone() {
        return new FramedButtonBlock(BlockType.FRAMED_STONE_BUTTON, BlockSetType.STONE, 20);
    }

    public static final class ButtonStateMerger
    implements StateMerger {
        private final StateMerger ignoringMerger = StateMerger.ignoring(WrapHelper.IGNORE_ALWAYS);

        private ButtonStateMerger() {
        }

        @Override
        public BlockState apply(BlockState state) {
            Direction dir;
            AttachFace face = (AttachFace)(state = this.ignoringMerger.apply(state)).getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE);
            if (face != AttachFace.WALL && ((dir = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) == Direction.SOUTH || dir == Direction.WEST)) {
                state = (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)dir.getOpposite());
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoringMerger.getHandledProperties(block), Set.of(FramedLargeButtonBlock.FACING));
        }
    }
}

