/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.cube.FramedStorageBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedChestBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.capability.CompoundStorageBlockItemHandler;
import xfacthd.framedblocks.common.capability.IStorageBlockItemHandler;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;
import xfacthd.framedblocks.common.data.property.LatchType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedChestBlock
extends FramedStorageBlock {
    public static final DoubleBlockCombiner.Combiner<FramedChestBlockEntity, Optional<IStorageBlockItemHandler>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<FramedChestBlockEntity, Optional<IStorageBlockItemHandler>>(){

        public Optional<IStorageBlockItemHandler> acceptDouble(FramedChestBlockEntity first, FramedChestBlockEntity second) {
            return Optional.of(new CompoundStorageBlockItemHandler(first.getItemHandler(), second.getItemHandler()));
        }

        public Optional<IStorageBlockItemHandler> acceptSingle(FramedChestBlockEntity single) {
            return Optional.of(single.getItemHandler());
        }

        public Optional<IStorageBlockItemHandler> acceptNone() {
            return Optional.empty();
        }
    };
    public static final DoubleBlockCombiner.Combiner<FramedChestBlockEntity, ChestState> STATE_COMBINER = new DoubleBlockCombiner.Combiner<FramedChestBlockEntity, ChestState>(){

        public ChestState acceptDouble(FramedChestBlockEntity first, FramedChestBlockEntity second) {
            ChestState stateOne = (ChestState)((Object)first.getBlockState().getValue(PropertyHolder.CHEST_STATE));
            ChestState stateTwo = (ChestState)((Object)second.getBlockState().getValue(PropertyHolder.CHEST_STATE));
            return stateOne != ChestState.CLOSED ? stateOne : stateTwo;
        }

        public ChestState acceptSingle(FramedChestBlockEntity single) {
            return (ChestState)((Object)single.getBlockState().getValue(PropertyHolder.CHEST_STATE));
        }

        public ChestState acceptNone() {
            return ChestState.CLOSED;
        }
    };
    public static final DoubleBlockCombiner.Combiner<FramedChestBlockEntity, OptionalLong> OPENNESS_COMBINER = new DoubleBlockCombiner.Combiner<FramedChestBlockEntity, OptionalLong>(){

        public OptionalLong acceptDouble(FramedChestBlockEntity first, FramedChestBlockEntity second) {
            ChestState stateOne = (ChestState)((Object)first.getBlockState().getValue(PropertyHolder.CHEST_STATE));
            ChestState stateTwo = (ChestState)((Object)second.getBlockState().getValue(PropertyHolder.CHEST_STATE));
            return OptionalLong.of(Math.min(first.getLastChangeTime(stateOne), second.getLastChangeTime(stateTwo)));
        }

        public OptionalLong acceptSingle(FramedChestBlockEntity single) {
            ChestState state = (ChestState)((Object)single.getBlockState().getValue(PropertyHolder.CHEST_STATE));
            return OptionalLong.of(single.getLastChangeTime(state));
        }

        public OptionalLong acceptNone() {
            return OptionalLong.empty();
        }
    };
    public static final DoubleBlockCombiner.Combiner<FramedChestBlockEntity, Component> TITLE_COMBINER = new DoubleBlockCombiner.Combiner<FramedChestBlockEntity, Component>(){

        public Component acceptDouble(FramedChestBlockEntity first, FramedChestBlockEntity second) {
            return first.hasCustomName() ? first.getName() : second.getName();
        }

        public Component acceptSingle(FramedChestBlockEntity single) {
            return single.getName();
        }

        public Component acceptNone() {
            return FramedChestBlockEntity.TITLE;
        }
    };

    public FramedChestBlock() {
        super(BlockType.FRAMED_CHEST);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.CHEST_STATE, PropertyHolder.LATCH_TYPE, BlockStateProperties.CHEST_TYPE, BlockStateProperties.WATERLOGGED});
        FramedUtils.removeProperty(builder, FramedProperties.SOLID);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withWater()).withCustom((state, modCtx) -> {
            Direction adjDir;
            Direction dir = ctx.getHorizontalDirection().getOpposite();
            ChestType type = ChestType.SINGLE;
            boolean secondaryUse = modCtx.isSecondaryUseActive();
            Direction face = modCtx.getClickedFace();
            if (face.getAxis().isHorizontal() && secondaryUse && (adjDir = this.getPotentialNeighborFacing((BlockPlaceContext)modCtx, face.getOpposite())) != null && adjDir.getAxis() != face.getAxis()) {
                dir = adjDir;
                ChestType chestType = type = adjDir.getCounterClockWise() == face.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
            }
            if (type == ChestType.SINGLE && !secondaryUse) {
                if (dir == this.getPotentialNeighborFacing((BlockPlaceContext)modCtx, dir.getClockWise())) {
                    type = ChestType.LEFT;
                } else if (dir == this.getPotentialNeighborFacing((BlockPlaceContext)modCtx, dir.getCounterClockWise())) {
                    type = ChestType.RIGHT;
                }
            }
            return (BlockState)((BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)type);
        })).build();
    }

    @Nullable
    private Direction getPotentialNeighborFacing(BlockPlaceContext ctx, Direction side) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(side));
        if (state.is((Block)this) && state.getValue((Property)BlockStateProperties.CHEST_TYPE) == ChestType.SINGLE) {
            return (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        }
        return null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && !ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos) && (blockEntity = level.getBlockEntity(pos)) instanceof FramedStorageBlockEntity) {
            FramedStorageBlockEntity be = (FramedStorageBlockEntity)blockEntity;
            be.open((ServerPlayer)player);
            player.awardStat(Stats.CUSTOM.get((Object)Stats.OPEN_CHEST));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)Utils.FRAMED_HAMMER.value())) {
            if (!level.isClientSide()) {
                state = (BlockState)state.setValue(PropertyHolder.LATCH_TYPE, (Comparable)((Object)((LatchType)((Object)state.getValue(PropertyHolder.LATCH_TYPE))).next()));
                level.setBlock(pos, state, 3);
            }
            return true;
        }
        return false;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction dir, BlockState adjState, LevelAccessor level, BlockPos pos, BlockPos adjPos) {
        BlockState newState = super.updateShape(state, dir, adjState, level, pos, adjPos);
        if (adjState.is((Block)this) && dir.getAxis().isHorizontal()) {
            Direction adjFacing;
            ChestType type = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE);
            ChestType adjType = (ChestType)adjState.getValue((Property)BlockStateProperties.CHEST_TYPE);
            if (type != ChestType.SINGLE || adjType == ChestType.SINGLE) {
                return newState;
            }
            Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            if (facing == (adjFacing = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR)) && FramedChestBlock.getConnectionDirection(adjState) == dir.getOpposite()) {
                return (BlockState)newState.setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)adjType.getOpposite());
            }
        } else if (FramedChestBlock.getConnectionDirection(state) == dir) {
            return (BlockState)newState.setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)ChestType.SINGLE);
        }
        return newState;
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (state.getValue((Property)BlockStateProperties.CHEST_TYPE) != ChestType.SINGLE) {
            return state;
        }
        return super.rotate(state, face, rot);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = rot.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        state = state.rotate(mirror.getRotation((Direction)state.getValue((Property)FramedProperties.FACING_HOR)));
        if (mirror != Mirror.NONE) {
            ChestType type = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE);
            state = (BlockState)state.setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)type.getOpposite());
        }
        return state;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        if (ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos)) {
            return 0;
        }
        return super.getAnalogOutputSignal(state, level, pos);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedChestBlockEntity(pos, state);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity be = (FramedChestBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide() || state.getValue(PropertyHolder.CHEST_STATE) != ChestState.CLOSING) {
            return null;
        }
        return Utils.createBlockEntityTicker(type, (BlockEntityType)FBContent.BE_TYPE_FRAMED_CHEST.value(), FramedChestBlockEntity::tick);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.LATCH_TYPE, (Comparable)((Object)((LatchType)((Object)state.getValue(PropertyHolder.LATCH_TYPE)))));
    }

    public static DoubleBlockCombiner.NeighborCombineResult<? extends FramedChestBlockEntity> combine(FramedChestBlockEntity be, boolean override) {
        return FramedChestBlock.combine(be.getBlockState(), be.getLevel(), be.getBlockPos(), override);
    }

    public static DoubleBlockCombiner.NeighborCombineResult<? extends FramedChestBlockEntity> combine(BlockState state, Level level, BlockPos pos, boolean override) {
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)FBContent.BE_TYPE_FRAMED_CHEST.value()), FramedChestBlock::getDoubleBlockType, FramedChestBlock::getConnectionDirection, (DirectionProperty)FramedProperties.FACING_HOR, (BlockState)state, (LevelAccessor)level, (BlockPos)pos, override ? (l, p) -> false : ChestBlock::isChestBlockedAt);
    }

    private static DoubleBlockCombiner.BlockType getDoubleBlockType(BlockState state) {
        return switch ((ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE)) {
            default -> throw new MatchException(null, null);
            case ChestType.SINGLE -> DoubleBlockCombiner.BlockType.SINGLE;
            case ChestType.LEFT -> DoubleBlockCombiner.BlockType.SECOND;
            case ChestType.RIGHT -> DoubleBlockCombiner.BlockType.FIRST;
        };
    }

    public static Direction getConnectionDirection(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return switch ((ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE)) {
            default -> throw new MatchException(null, null);
            case ChestType.SINGLE -> dir;
            case ChestType.LEFT -> dir.getClockWise();
            case ChestType.RIGHT -> dir.getCounterClockWise();
        };
    }
}

