/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.particle;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.common.particle.FluidParticleOptions;

public final class FluidSpriteParticle
extends TextureSheetParticle {
    private final BlockPos pos;
    private final float uo;
    private final float vo;
    private final int brightness;

    public FluidSpriteParticle(ClientLevel level, double x, double y, double z, double sx, double sy, double sz, Fluid fluid) {
        super(level, x, y, z, sx, sy, sz);
        this.pos = BlockPos.containing((double)x, (double)y, (double)z);
        this.gravity = 1.0f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.brightness = fluid.getFluidType().getLightLevel(fluid.defaultFluidState(), (BlockAndTintGetter)level, this.pos);
        int tint = ClientUtils.getFluidColor((BlockAndTintGetter)level, this.pos, fluid.defaultFluidState());
        this.rCol = 0.6f * (float)(tint >> 16 & 0xFF) / 255.0f;
        this.gCol = 0.6f * (float)(tint >> 8 & 0xFF) / 255.0f;
        this.bCol = 0.6f * (float)(tint & 0xFF) / 255.0f;
        ResourceLocation stillTex = Objects.requireNonNullElse(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(), MissingTextureAtlasSprite.getLocation());
        this.setSprite((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stillTex));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    public int getLightColor(float partialTick) {
        int light = this.level.hasChunkAt(this.pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.pos) : 0;
        int block = Math.max(this.brightness, LightTexture.block((int)light));
        return LightTexture.pack((int)block, (int)LightTexture.sky((int)light));
    }

    public static final class Provider
    implements ParticleProvider<FluidParticleOptions> {
        @Nullable
        public Particle createParticle(FluidParticleOptions options, ClientLevel level, double x, double y, double z, double sx, double sy, double sz) {
            if (options.fluid() != Fluids.EMPTY) {
                return new FluidSpriteParticle(level, x, y, z, sx, sy, sz, options.fluid());
            }
            return null;
        }
    }
}

