/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedVerticalStairsGeometry
extends Geometry {
    private final boolean vertical;
    private final boolean top;
    private final boolean bottom;
    private final boolean forward;
    private final boolean counterClockWise;
    private final Direction dir;

    public FramedVerticalStairsGeometry(GeometryFactory.Context ctx) {
        StairsType type = (StairsType)((Object)ctx.state().getValue(PropertyHolder.STAIRS_TYPE));
        this.vertical = type == StairsType.VERTICAL;
        this.top = type.isTop();
        this.bottom = type.isBottom();
        this.forward = type.isForward();
        this.counterClockWise = type.isCounterClockwise();
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.vertical && (quadDir == this.dir.getOpposite() || quadDir == this.dir.getClockWise())) {
            Direction cutDir = quadDir == this.dir.getOpposite() ? this.dir.getClockWise() : this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir.getOpposite(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
        if (quadDir == Direction.UP && !this.top || quadDir == Direction.DOWN && !this.bottom) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
        }
        if (quadDir == this.dir.getOpposite() && !this.vertical) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.5f)).applyIf(Modifiers.cutSideUpDown(this.bottom, 0.5f), this.counterClockWise).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.5f)).applyIf(Modifiers.cutSideUpDown(this.bottom, 0.5f), this.forward).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            if (this.counterClockWise) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.5f)).apply(Modifiers.cutSideUpDown(!this.bottom, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        }
        if (quadDir == this.dir.getClockWise() && !this.vertical) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).applyIf(Modifiers.cutSideUpDown(this.bottom, 0.5f), this.forward).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).applyIf(Modifiers.cutSideUpDown(this.bottom, 0.5f), this.counterClockWise).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            if (this.forward) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutSideUpDown(!this.bottom, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        }
        if (quadDir == Direction.UP && this.top || quadDir == Direction.DOWN && this.bottom) {
            QuadModifier.of(quad).applyIf(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f), this.counterClockWise).applyIf(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f), this.forward).export(quadMap.get(quadDir));
            if (this.forward) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
            if (this.counterClockWise) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        }
        if (quadDir == this.dir && this.forward) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.bottom, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
        }
        if (quadDir == this.dir.getCounterClockWise() && this.counterClockWise) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.bottom, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

