/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeedge.modern;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopeedge.legacy.LegacyFramedSlopeEdgeGeometry;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedSlopeEdgeGeometry
extends Geometry {
    private final Direction dir;
    private final SlopeType type;
    private final boolean altType;
    private final boolean ySlope;

    private FramedSlopeEdgeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (SlopeType)((Object)ctx.state().getValue(PropertyHolder.SLOPE_TYPE));
        this.altType = (Boolean)ctx.state().getValue((Property)PropertyHolder.ALT_TYPE);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.altType) {
            if (this.type == SlopeType.HORIZONTAL) {
                if (quadDir == this.dir) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (quadDir == this.dir.getCounterClockWise()) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (!this.ySlope && quadDir == this.dir.getOpposite()) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.25f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                } else if (this.ySlope && quadDir == this.dir.getClockWise()) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.25f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.25f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                } else if (Utils.isY(quadDir)) {
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.5f, 0.5f)).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).export(quadMap.get(quadDir));
                }
            } else {
                boolean top;
                boolean bl = top = this.type == SlopeType.TOP;
                if (quadDir == this.dir) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (!top && quadDir == Direction.DOWN || top && quadDir == Direction.UP) {
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                } else if (!this.ySlope && quadDir == this.dir.getOpposite()) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.25f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.25f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(top ? Direction.DOWN : Direction.UP, 0.5f)).export(quadMap.get(null));
                } else if (this.ySlope && (!top && quadDir == Direction.UP || top && quadDir == Direction.DOWN)) {
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.25f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(top ? Direction.DOWN : Direction.UP, 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.25f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                } else if (quadDir == this.dir.getClockWise() || quadDir == this.dir.getCounterClockWise()) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.5f : 0.5f, top ? 0.5f : 1.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).export(quadMap.get(quadDir));
                }
            }
            return;
        }
        if (this.type == SlopeType.HORIZONTAL) {
            if (!this.ySlope && quadDir == this.dir.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.25f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.dir.getClockWise()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.25f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.25f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f, -0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir.getCounterClockWise()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else {
            boolean top;
            boolean bl = top = this.type == SlopeType.TOP;
            if (!this.ySlope && quadDir == this.dir.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.25f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.25f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(top ? Direction.UP : Direction.DOWN, 0.5f)).export(quadMap.get(null));
            } else if (this.ySlope && (!top && quadDir == Direction.UP || top && quadDir == Direction.DOWN)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.25f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(top ? Direction.UP : Direction.DOWN, 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.25f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
            } else if (quadDir == this.dir.getClockWise() || quadDir == this.dir.getCounterClockWise()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 0.5f : -0.5f, top ? -0.5f : 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).export(quadMap.get(quadDir));
            } else if (!top && quadDir == Direction.DOWN || top && quadDir == Direction.UP) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            }
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }

    public static Geometry create(GeometryFactory.Context ctx) {
        if (ClientConfig.VIEW.useLegacySlopeEdgeModel()) {
            return new LegacyFramedSlopeEdgeGeometry(ctx);
        }
        return new FramedSlopeEdgeGeometry(ctx);
    }
}

