/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.door;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedTrapDoorGeometry
extends Geometry {
    private static final float DEPTH = 0.1875f;
    private final Direction dir;
    private final boolean top;
    private final boolean open;

    public FramedTrapDoorGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.top = ctx.state().getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        this.open = (Boolean)ctx.state().getValue((Property)BlockStateProperties.OPEN);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.open) {
            if (quadDir == this.dir) {
                QuadModifier.of(quad).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.1875f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.1875f)).export(quadMap.get(quadDir));
            }
        } else if (this.top && quad.getDirection() == Direction.DOWN || !this.top && quad.getDirection() == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
        } else if (!Utils.isY(quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.1875f)).export(quadMap.get(quadDir));
        }
    }
}

