/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.blockentity.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

public class FramedBlockColor
implements BlockColor,
ItemColor {
    public static final FramedBlockColor INSTANCE = new FramedBlockColor();

    public int getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (level != null && pos != null) {
            BlockEntity be = level.getBlockEntity(pos);
            if (tintIndex < -1 && be instanceof IFramedDoubleBlockEntity) {
                IFramedDoubleBlockEntity dbe = (IFramedDoubleBlockEntity)be;
                tintIndex = ModelUtils.decodeSecondaryTintIndex(tintIndex);
                return dbe.getCamoTwo().getTintColor(level, pos, tintIndex);
            }
            if (tintIndex >= 0 && be instanceof FramedBlockEntity) {
                FramedBlockEntity fbe = (FramedBlockEntity)be;
                return fbe.getCamo().getTintColor(level, pos, tintIndex);
            }
        }
        return -1;
    }

    public int getColor(ItemStack stack, int tintIndex) {
        BlockItem item;
        Item item2 = stack.getItem();
        if (!(item2 instanceof BlockItem) || !((item2 = (item = (BlockItem)item2).getBlock()) instanceof IFramedBlock)) {
            return -1;
        }
        IFramedBlock block = (IFramedBlock)item2;
        if (!ConfigView.Client.INSTANCE.shouldRenderItemModelsWithCamo() || block.getItemModelSource() == null) {
            return -1;
        }
        CamoList camos = (CamoList)stack.getOrDefault(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY);
        if (tintIndex < -1 && block.getBlockType().isDoubleBlock()) {
            tintIndex = ModelUtils.decodeSecondaryTintIndex(tintIndex);
            return FastColor.ARGB32.opaque((int)camos.getCamo(1).getTintColor(stack, tintIndex));
        }
        if (tintIndex >= 0) {
            return FastColor.ARGB32.opaque((int)camos.getCamo(0).getTintColor(stack, tintIndex));
        }
        return -1;
    }
}

