/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;

public class PlacementStateBuilder<T extends PlacementStateBuilder<T>> {
    protected final Block block;
    protected final BlockPlaceContext ctx;
    @Nullable
    protected BlockState state;

    protected PlacementStateBuilder(Block block, BlockPlaceContext ctx) {
        this.block = block;
        this.ctx = ctx;
        this.state = block.defaultBlockState();
    }

    public static PlacementStateBuilder<?> of(Block block, BlockPlaceContext ctx) {
        return new PlacementStateBuilder(block, ctx);
    }

    public final T withHorizontalFacing() {
        return this.withHorizontalFacing(false);
    }

    public final T withHorizontalFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction dir = this.ctx.getHorizontalDirection();
        if (opposite) {
            dir = dir.getOpposite();
        }
        this.state = (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        return this.self();
    }

    public final T withTargetOrHorizontalFacing() {
        return this.withTargetOrHorizontalFacing(false);
    }

    public final T withTargetOrHorizontalFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction face = this.ctx.getClickedFace();
        if (!Utils.isY(face)) {
            if (!opposite) {
                face = face.getOpposite();
            }
            this.state = (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)face);
            return this.self();
        }
        return this.withHorizontalFacing(opposite);
    }

    public final T withHorizontalTargetFacing() {
        return this.withHorizontalTargetFacing(false);
    }

    public final T withHorizontalTargetFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction face = this.ctx.getClickedFace();
        if (Utils.isY(face)) {
            this.state = null;
            return this.self();
        }
        if (!opposite) {
            face = face.getOpposite();
        }
        this.state = (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)face);
        return this.self();
    }

    public final T withTargetFacing() {
        return this.withTargetFacing(false);
    }

    public final T withTargetFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction face = this.ctx.getClickedFace();
        if (!opposite) {
            face = face.getOpposite();
        }
        this.state = (BlockState)this.state.setValue((Property)BlockStateProperties.FACING, (Comparable)face);
        return this.self();
    }

    public final T withHalfOrHorizontalFacing() {
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.getClickedFace();
        this.state = Utils.isY(side) ? (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)this.ctx.getHorizontalDirection()) : (Utils.fractionInDir(this.ctx.getClickLocation(), side.getCounterClockWise()) > 0.5 ? (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)side.getOpposite().getClockWise()) : (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)side.getOpposite()));
        return this.self();
    }

    public final T withHalfOrQuarterFacing() {
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.getClickedFace();
        if (Utils.isY(side)) {
            double z;
            Direction dir;
            Vec3 hitVec = this.ctx.getClickLocation();
            double x = Utils.fractionInDir(hitVec, Direction.EAST);
            if (x > 0.5 != Utils.isPositive(dir = (z = Utils.fractionInDir(hitVec, Direction.SOUTH)) > 0.5 ? Direction.SOUTH : Direction.NORTH)) {
                dir = dir.getClockWise();
            }
            this.state = (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
            return this.self();
        }
        return this.withHalfOrHorizontalFacing();
    }

    public final T withHalfFacing() {
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.getClickedFace();
        if (Utils.isY(side)) {
            Direction dir = this.ctx.getHorizontalDirection();
            double xz = Utils.fractionInDir(this.ctx.getClickLocation(), dir.getClockWise());
            if (xz > 0.5) {
                dir = dir.getClockWise();
            }
            this.state = (BlockState)this.state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
            return this.self();
        }
        return this.withHalfOrHorizontalFacing();
    }

    public final T withClickedAxis() {
        if (this.state != null) {
            this.state = (BlockState)this.state.setValue((Property)BlockStateProperties.AXIS, (Comparable)this.ctx.getClickedFace().getAxis());
        }
        return this.self();
    }

    public final T withTop() {
        return this.withTop(FramedProperties.TOP);
    }

    public final T withTop(BooleanProperty prop) {
        double y;
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.getClickedFace();
        this.state = side == Direction.DOWN ? (BlockState)this.state.setValue((Property)prop, (Comparable)Boolean.valueOf(true)) : (side == Direction.UP ? (BlockState)this.state.setValue((Property)prop, (Comparable)Boolean.valueOf(false)) : (BlockState)this.state.setValue((Property)prop, (Comparable)Boolean.valueOf((y = Utils.fractionInDir(this.ctx.getClickLocation(), Direction.UP)) >= 0.5)));
        return this.self();
    }

    public final T tryWithWater() {
        if (this.state != null && this.state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return this.withWater();
        }
        return this.self();
    }

    public final T withWater() {
        if (this.state == null) {
            return this.self();
        }
        FluidState fluidState = this.ctx.getLevel().getFluidState(this.ctx.getClickedPos());
        this.state = (BlockState)this.state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return this.self();
    }

    public final T withYSlope(boolean ySlope) {
        if (this.state == null) {
            return this.self();
        }
        this.state = (BlockState)this.state.setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope));
        return this.self();
    }

    public final T withCustom(BiFunction<BlockState, BlockPlaceContext, @Nullable BlockState> modifier) {
        if (this.state == null) {
            return this.self();
        }
        this.state = modifier.apply(this.state, this.ctx);
        return this.self();
    }

    public final T validate(BiPredicate<BlockState, BlockPlaceContext> validator) {
        if (this.state != null && !validator.test(this.state, this.ctx)) {
            this.state = null;
        }
        return this.self();
    }

    @Nullable
    public final BlockState build() {
        return this.state;
    }

    protected final T self() {
        return (T)this;
    }
}

