/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import org.jetbrains.annotations.ApiStatus;

public interface IBlockEntityExtension {
    private BlockEntity self() {
        return (BlockEntity)this;
    }

    default public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        CompoundTag compoundtag = pkt.getTag();
        if (!compoundtag.isEmpty()) {
            this.self().loadWithComponents(compoundtag, lookupProvider);
        }
    }

    default public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.self().loadWithComponents(tag, lookupProvider);
    }

    public CompoundTag getPersistentData();

    default public void onChunkUnloaded() {
    }

    default public void onLoad() {
        this.requestModelDataUpdate();
    }

    default public void requestModelDataUpdate() {
        ModelDataManager modelDataManager;
        BlockEntity te = this.self();
        Level level = te.getLevel();
        if (level != null && level.isClientSide && (modelDataManager = level.getModelDataManager()) != null) {
            modelDataManager.requestRefresh(te);
        }
    }

    default public ModelData getModelData() {
        return ModelData.EMPTY;
    }

    default public boolean hasCustomOutlineRendering(Player player) {
        return false;
    }

    @ApiStatus.NonExtendable
    default public void invalidateCapabilities() {
        BlockEntity be = this.self();
        Level level = be.getLevel();
        if (level != null) {
            level.invalidateCapabilities(be.getBlockPos());
        }
    }
}

