/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;

public final class RenderTypeHelper {
    public static RenderType getEntityRenderType(RenderType chunkRenderType, boolean cull) {
        if (chunkRenderType != RenderType.translucent()) {
            return Sheets.cutoutBlockSheet();
        }
        return cull || !Minecraft.useShaderTransparency() ? Sheets.translucentCullBlockSheet() : Sheets.translucentItemSheet();
    }

    public static RenderType getMovingBlockRenderType(RenderType renderType) {
        if (renderType == RenderType.translucent()) {
            return RenderType.translucentMovingBlock();
        }
        return renderType;
    }

    public static RenderType getFallbackItemRenderType(ItemStack stack, BakedModel model, boolean cull) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(blockItem.getBlock().defaultBlockState(), RandomSource.create((long)42L), ModelData.EMPTY);
            if (renderTypes.contains(RenderType.translucent())) {
                return RenderTypeHelper.getEntityRenderType(RenderType.translucent(), cull);
            }
            return Sheets.cutoutBlockSheet();
        }
        return cull ? Sheets.translucentCullBlockSheet() : Sheets.translucentItemSheet();
    }

    private RenderTypeHelper() {
    }
}

