/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.sailing.warden;

import com.cursee.monolib.core.sailing.warden.DomainRules;
import com.cursee.monolib.core.sailing.warden.ZoneIdentifier;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SailingWarden {
    public static final Map<String, String> UNSAFE_PATH_TO_UNSAFE_HOST_MAP = new HashMap<String, String>();

    public static void processDirectoryOrFilePathStrings(String ... filepathArguments) {
        DomainRules rules = DomainRules.builtin();
        for (String filepath : filepathArguments) {
            try {
                if (SailingWarden.checkFile(rules, Paths.get(filepath, new String[0]).toFile())) continue;
                System.out.println("No matching files were found.");
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException("Invalid path specified. '" + filepath + "'");
            }
        }
    }

    private static boolean checkFile(DomainRules rules, File target) {
        boolean hasMatch = false;
        if (!target.exists()) {
            throw new IllegalArgumentException("The file does not exist! '" + target.getAbsolutePath() + "'");
        }
        if (target.isFile()) {
            ZoneIdentifier zoneId = ZoneIdentifier.of(target);
            if (zoneId != null && rules.test(zoneId)) {
                UNSAFE_PATH_TO_UNSAFE_HOST_MAP.put(target.getName(), zoneId.getHost());
                hasMatch = true;
            }
        } else if (target.isDirectory()) {
            for (File subTarget : Objects.requireNonNull(target.listFiles())) {
                hasMatch = hasMatch || SailingWarden.checkFile(rules, subTarget);
            }
        }
        return hasMatch;
    }
}

