/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.registry;

import com.cursee.monolib.core.registry.ModBlocks;
import com.cursee.monolib.core.registry.ModItems;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;

public class RegistryNeoForge {
    private static final AtomicReference<IEventBus> MOD_EVENT_BUS = new AtomicReference<Object>(null);
    private static final Set<Item> CREATIVE_MODE_TAB_ITEMS = new LinkedHashSet<Item>();

    public static void register(IEventBus modEventBus) {
        if (MOD_EVENT_BUS.get() == null) {
            MOD_EVENT_BUS.set(modEventBus);
        }
        RegistryNeoForge.bind(Registries.BLOCK, consumer -> ModBlocks.register(consumer));
        RegistryNeoForge.bindForItems(ModItems::register);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        MOD_EVENT_BUS.get().addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static void bindForItems(Consumer<BiConsumer<Item, ResourceLocation>> source) {
        MOD_EVENT_BUS.get().addListener(event -> {
            if (event.getRegistryKey().equals(Registries.ITEM)) {
                source.accept((t, rl) -> {
                    CREATIVE_MODE_TAB_ITEMS.add((Item)t);
                    event.register(Registries.ITEM, rl, () -> t);
                });
            }
        });
    }
}

