/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.config;

import com.cursee.monolib.core.config.SimpleConfig;
import com.cursee.monolib.util.toml.DatePolicy;
import com.cursee.monolib.util.toml.IndentationPolicy;
import com.cursee.monolib.util.toml.MapValueWriter;
import com.cursee.monolib.util.toml.ValueWriter;
import com.cursee.monolib.util.toml.ValueWriters;
import com.cursee.monolib.util.toml.WriterContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TimeZone;

public class SimpleConfigWriter {
    public static void writeObjectToFile(Map<String, ?> from, File target) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            SimpleConfigWriter.writeObjectToOutputStream(from, outputStream);
        }
    }

    public static void writeObjectToOutputStream(Map<String, ?> from, OutputStream target) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(target, StandardCharsets.UTF_8);
        SimpleConfigWriter.writeObjectToOutputStreamWriter(from, writer);
        writer.flush();
    }

    public static void writeObjectToOutputStreamWriter(Map<String, ?> from, Writer target) throws IOException {
        ValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(from);
        if (valueWriter != MapValueWriter.MAP_VALUE_WRITER) {
            throw new IllegalArgumentException("An object of class " + from.getClass().getSimpleName() + " is invalid for SimpleConfig parsing.");
        }
        WriterContext context = new WriterContext(new IndentationPolicy(0, 0, 0), new DatePolicy(TimeZone.getTimeZone("UTC"), false), target);
        valueWriter.write(from, context);
    }

    public static SimpleConfig writeObjectToFileWithReturn(Map<String, ?> from, File target) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            SimpleConfig simpleConfig = SimpleConfigWriter.writeObjectToOutputStreamWithReturn(from, target, outputStream);
            return simpleConfig;
        }
    }

    public static SimpleConfig writeObjectToOutputStreamWithReturn(Map<String, ?> from, File file, OutputStream target) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(target, StandardCharsets.UTF_8);
        SimpleConfig toReturn = SimpleConfigWriter.writeObjectToOutputStreamWriterWithReturn(from, file, writer);
        writer.flush();
        return toReturn;
    }

    public static SimpleConfig writeObjectToOutputStreamWriterWithReturn(Map<String, ?> from, File file, Writer target) throws IOException {
        ValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(from);
        if (valueWriter != MapValueWriter.MAP_VALUE_WRITER) {
            throw new IllegalArgumentException("An object of class " + from.getClass().getSimpleName() + " is invalid for SimpleConfig parsing.");
        }
        WriterContext context = new WriterContext(new IndentationPolicy(0, 0, 0), new DatePolicy(TimeZone.getTimeZone("UTC"), false), target);
        valueWriter.write(from, context);
        return SimpleConfig.read(file);
    }
}

