/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.poolelement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;

public record DelegatingConfig(StructurePoolElement delegate, Optional<InclusiveRange<Integer>> allowedDepth, Optional<Integer> forcedCount, Optional<Integer> maxCount, Optional<TerrainAdjustment> overrideTerrainAdaption) {
    public static final MapCodec<DelegatingConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructurePoolElement.CODEC.fieldOf("delegate").forGetter(DelegatingConfig::delegate), (App)InclusiveRange.INT.optionalFieldOf("allowed_depth").forGetter(DelegatingConfig::allowedDepth), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("forced_count").forGetter(DelegatingConfig::forcedCount), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("max_count").forGetter(DelegatingConfig::maxCount), (App)TerrainAdjustment.CODEC.optionalFieldOf("override_terrain_adaption").forGetter(DelegatingConfig::overrideTerrainAdaption)).apply((Applicative)instance, DelegatingConfig::new));

    public DelegatingConfig {
        if (forcedCount.isPresent() && maxCount.isPresent()) {
            throw new IllegalArgumentException("min_count and max_count cannot both be present.");
        }
    }

    public boolean shouldSkip(int depth, int count) {
        boolean validDepth = this.allowedDepth.map(range -> range.isValueInRange((Comparable)Integer.valueOf(depth))).orElse(true);
        boolean validCount = this.forcedCount.map(forced -> count < forced).orElse(true) != false && this.maxCount.map(max -> count < max).orElse(true) != false;
        return !validDepth || !validCount;
    }
}

