/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.InclusiveRange;

public record MultipleOfPlacementCondition(List<PlacementCondition> conditions, InclusiveRange<Integer> allowedCount) implements PlacementCondition
{
    public static final MapCodec<MultipleOfPlacementCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlacementCondition.BASE_CODEC.listOf().fieldOf("conditions").forGetter(MultipleOfPlacementCondition::conditions), (App)InclusiveRange.INT.fieldOf("allowed_count").forGetter(MultipleOfPlacementCondition::allowedCount)).apply((Applicative)instance, MultipleOfPlacementCondition::new));

    @Override
    public boolean test(PlacementCondition.Context context, BlockPos pos) {
        int count = 0;
        for (PlacementCondition condition : this.conditions) {
            if (!condition.test(context, pos) || (Integer)this.allowedCount.maxInclusive() >= ++count) continue;
            return false;
        }
        return this.allowedCount.isValueInRange((Comparable)Integer.valueOf(count));
    }

    @Override
    public MapCodec<? extends PlacementCondition> codec() {
        return CODEC;
    }
}

