/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.densityfunction;

import com.mojang.serialization.MapCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import org.jetbrains.annotations.NotNull;

public record MergedDensityFunction(DensityFunction original, DensityFunction wrapped, DensityFunction full) implements DensityFunction
{
    public static final KeyDispatchDataCodec<DensityFunction> CODEC = KeyDispatchDataCodec.of((MapCodec)HOLDER_HELPER_CODEC.xmap(df -> {
        DensityFunction densityFunction;
        if (df instanceof DensityFunctions.HolderHolder) {
            DensityFunctions.HolderHolder hh = (DensityFunctions.HolderHolder)df;
            densityFunction = (DensityFunction)hh.function().value();
        } else {
            densityFunction = df;
        }
        return densityFunction;
    }, MergedDensityFunction::unwrappedOriginal).fieldOf("original"));

    private static DensityFunction unwrappedOriginal(DensityFunction df) {
        DensityFunction densityFunction;
        if (df instanceof MergedDensityFunction) {
            MergedDensityFunction merged = (MergedDensityFunction)df;
            densityFunction = MergedDensityFunction.unwrappedOriginal(merged.original());
        } else {
            densityFunction = df;
        }
        return densityFunction;
    }

    public double compute(DensityFunction.FunctionContext context) {
        return this.full.compute(context);
    }

    public void fillArray(double[] doubles, DensityFunction.ContextProvider contextProvider) {
        this.full.fillArray(doubles, contextProvider);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return this.full.mapAll(visitor);
    }

    public double minValue() {
        return this.full.minValue();
    }

    public double maxValue() {
        return this.full.maxValue();
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

