/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacerholderFillOperation
implements ITickedWorldOperation {
    private BlockPos startPos;
    private final BlockPos endPos;
    private final double yStretch;
    private final double circleRadiusMult;
    private final int heightOffset;
    private final int minDistToBlocks;
    private final ChangeStorage storage;

    public PlacerholderFillOperation(BlockPos startPos, BlockPos endPos, @Nullable Player player, double yStretch, double circleRadiusMult, int heightOffset, int minDistToBlocks) {
        this.startPos = new BlockPos(Math.min(startPos.getX(), endPos.getX()), Math.min(startPos.getY(), endPos.getY()), Math.min(startPos.getZ(), endPos.getZ()));
        this.yStretch = yStretch;
        this.circleRadiusMult = circleRadiusMult;
        this.heightOffset = heightOffset;
        this.minDistToBlocks = minDistToBlocks;
        this.endPos = new BlockPos(Math.max(startPos.getX(), endPos.getX()), Math.max(startPos.getY(), endPos.getY()), Math.max(startPos.getZ(), endPos.getZ()));
        this.storage = new ChangeStorage((Component)Component.literal((String)"FILL_TOP_PLACEHOLDERS"), player != null ? player.getUUID() : UUID.randomUUID());
    }

    @Override
    public boolean apply(ServerLevel world) {
        this.fillSchematicTopWithPlaceholders(world, this.yStretch, this.circleRadiusMult, this.heightOffset, this.minDistToBlocks);
        return true;
    }

    @Override
    @NotNull
    public ChangeStorage getChangeStorage() {
        return this.storage;
    }

    private void fillSchematicTopWithPlaceholders(ServerLevel world, double yStretch, double circleRadiusMult, int heightOffset, int minDistToBlocks) {
        for (int x = this.startPos.getX(); x <= this.endPos.getX(); ++x) {
            for (int z = this.startPos.getZ(); z <= this.endPos.getZ(); ++z) {
                BlockPos current;
                for (int y = this.endPos.getY(); y > this.startPos.getY() && this.checkDistance(current = new BlockPos(x, y, z), this.startPos, this.endPos, yStretch, circleRadiusMult, heightOffset) && this.checkSurroundingBlocks((Level)world, current, minDistToBlocks); --y) {
                    this.storage.addPreviousDataFor(current, (Level)world);
                    world.setBlock(current, ((BlockSubstitution)((Object)ModBlocks.blockSubstitution.get())).defaultBlockState(), 3);
                    this.storage.addPostDataFor(current, (Level)world);
                }
            }
        }
    }

    private boolean checkDistance(BlockPos comparedPos, BlockPos corner1, BlockPos corner2, double yStretch, double circleRadiusMult, int heightOffset) {
        double zDiff;
        double yDiff;
        BlockPos center = corner1.offset((Vec3i)corner2);
        center = new BlockPos(center.getX() / 2, (int)((double)(center.getY() / 2) + (double)Math.abs(corner1.getY() - corner2.getY()) * 0.1) + heightOffset, center.getZ() / 2);
        if (comparedPos.getY() < center.getY()) {
            return false;
        }
        int xLength = Math.abs(corner1.getX() - corner2.getX());
        int zLength = Math.abs(corner1.getZ() - corner2.getZ());
        double xDiff = (double)comparedPos.getX() + 0.5 - (double)center.getX();
        return !(Math.sqrt(xDiff * xDiff * ((double)zLength / (double)xLength) + (yDiff = (double)comparedPos.getY() + 0.5 - (double)center.getY()) * yDiff * 2.0 * yStretch + (zDiff = (double)comparedPos.getZ() + 0.5 - (double)center.getZ()) * zDiff * ((double)xLength / (double)zLength)) < (double)Math.min(xLength, zLength) * 0.4 * circleRadiusMult);
    }

    private boolean checkSurroundingBlocks(Level level, BlockPos checkPos, int minDistToBlocks) {
        if (minDistToBlocks <= 0) {
            return true;
        }
        for (int x = -minDistToBlocks; x <= minDistToBlocks; ++x) {
            for (int y = -minDistToBlocks; y <= minDistToBlocks; ++y) {
                for (int z = -minDistToBlocks; z <= minDistToBlocks; ++z) {
                    BlockState state = level.getBlockState(checkPos.offset(x, y, z));
                    if (state.isAir() || state.getBlock() == ModBlocks.blockSubstitution.get()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

