/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.InventoryUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public interface IStructureHandler {
    public void setBlueprint(Blueprint var1);

    public void setMd5(String var1);

    public String getMd5();

    default public boolean isCorrectMD5(String otherMD5) {
        Log.getLogger().info("isCorrectMD5: md5:" + this.getMd5() + " other:" + otherMD5);
        if (this.getMd5() == null || otherMD5 == null) {
            return false;
        }
        return this.getMd5().compareTo(otherMD5) == 0;
    }

    public Blueprint getBluePrint();

    public Level getWorld();

    public BlockPos getWorldPos();

    public RotationMirror getRotationMirror();

    @Nullable
    public IItemHandler getInventory();

    public void triggerSuccess(BlockPos var1, List<ItemStack> var2, boolean var3);

    public void triggerEntitySuccess(BlockPos var1, List<ItemStack> var2, boolean var3);

    public boolean isCreative();

    public boolean hasBluePrint();

    public int getStepsPerCall();

    public int getMaxBlocksCheckedPerCall();

    public boolean isStackFree(@Nullable ItemStack var1);

    public boolean allowReplace();

    public ItemStack getHeldItem();

    public boolean replaceWithSolidBlock(BlockState var1);

    public boolean fancyPlacement();

    public boolean shouldBlocksBeConsideredEqual(BlockState var1, BlockState var2);

    public boolean hasRequiredItems(List<ItemStack> var1);

    default public void consume(List<ItemStack> requiredItems) {
        if (this.getInventory() != null) {
            for (ItemStack tempStack : requiredItems) {
                if (ItemStackUtils.isEmpty(tempStack)) continue;
                InventoryUtils.consumeStack(tempStack, this.getInventory());
            }
        }
    }

    default public BlockPos getProgressPosInWorld(BlockPos localPos) {
        return this.getWorldPos().subtract((Vec3i)this.getBluePrint().getPrimaryBlockOffset()).offset((Vec3i)localPos);
    }

    default public BlockPos getStructurePosFromWorld(BlockPos worldPos) {
        return this.getBluePrint().getPrimaryBlockOffset().offset((Vec3i)worldPos.subtract((Vec3i)this.getWorldPos()));
    }

    public void prePlacementLogic(BlockPos var1, BlockState var2, List<ItemStack> var3);

    public BlockState getSolidBlockForPos(BlockPos var1, Function<BlockPos, @Nullable BlockState> var2);

    public boolean isReady();

    default public void onCompletion() {
    }
}

