/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateClientRender
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"structurize", (String)"update_client_render", UpdateClientRender::new);
    private final BlockPos from;
    private final BlockPos to;

    protected UpdateClientRender(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.from = buf.readBlockPos();
        this.to = buf.readBlockPos();
    }

    public UpdateClientRender(BlockPos from, BlockPos to) {
        super(TYPE);
        this.from = from;
        this.to = to;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.from);
        buf.writeBlockPos(this.to);
    }

    protected void onExecute(IPayloadContext context, Player player) {
        Minecraft.getInstance().levelRenderer.setBlocksDirty(this.from.getX(), this.from.getY(), this.from.getZ(), this.to.getX(), this.to.getY(), this.to.getZ());
    }
}

