/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.RemoveBlockOperation;
import com.ldtteam.structurize.operations.RemoveFilteredOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RemoveBlockMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"remove_block", RemoveBlockMessage::new);
    private final BlockPos from;
    private final BlockPos to;
    private final List<ItemStack> blocks;

    protected RemoveBlockMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.from = buf.readBlockPos();
        this.to = buf.readBlockPos();
        this.blocks = new ArrayList<ItemStack>();
        int blockCount = buf.readInt();
        for (int i = 0; i < blockCount; ++i) {
            this.blocks.add((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
        }
    }

    public RemoveBlockMessage(BlockPos pos1, BlockPos pos2, ItemStack stack) {
        this(pos1, pos2, List.of(stack));
    }

    public RemoveBlockMessage(BlockPos pos1, BlockPos pos2, List<ItemStack> stacks) {
        super(TYPE);
        this.from = pos1;
        this.to = pos2;
        this.blocks = stacks;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.from);
        buf.writeBlockPos(this.to);
        buf.writeInt(this.blocks.size());
        for (ItemStack block : this.blocks) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)block);
        }
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        if (this.blocks.size() > 1) {
            Manager.addToQueue(new RemoveFilteredOperation((Player)player, this.from, this.to, this.blocks));
            return;
        }
        if (!this.blocks.isEmpty()) {
            Manager.addToQueue(new RemoveBlockOperation((Player)player, this.from, this.to, this.blocks.get(0)));
        }
    }
}

