/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientBlueprintRequestMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"structurize", (String)"blueprint_request", ClientBlueprintRequestMessage::new);
    public final BuildToolPlacementMessage.HandlerType type;
    public final String handlerId;
    public final String structurePackId;
    public final String blueprintPath;
    public final BlockPos pos;
    public final RotationMirror rotationMirror;

    protected ClientBlueprintRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.type = BuildToolPlacementMessage.HandlerType.values()[buf.readInt()];
        this.handlerId = buf.readUtf(Short.MAX_VALUE);
        this.structurePackId = buf.readUtf(Short.MAX_VALUE);
        this.blueprintPath = buf.readUtf(Short.MAX_VALUE);
        this.pos = buf.readBlockPos();
        this.rotationMirror = RotationMirror.values()[buf.readInt()];
    }

    public ClientBlueprintRequestMessage(BuildToolPlacementMessage msg) {
        super(TYPE);
        this.type = msg.type;
        this.handlerId = msg.handlerId;
        this.structurePackId = msg.structurePackId;
        this.blueprintPath = msg.blueprintPath;
        this.pos = msg.pos;
        this.rotationMirror = msg.rotationMirror;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeUtf(this.handlerId);
        buf.writeUtf(this.structurePackId);
        buf.writeUtf(this.blueprintPath);
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.rotationMirror.ordinal());
    }

    protected void onExecute(IPayloadContext context, Player player) {
        ClientFutureProcessor.queueBlueprintData(new ClientFutureProcessor.BlueprintDataProcessingData(StructurePacks.getBlueprintDataFuture(this.structurePackId, this.blueprintPath), blueprintData -> {
            if (blueprintData != null) {
                new BlueprintSyncMessage(this, (byte[])blueprintData).sendToServer();
            }
        }));
    }
}

