/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.component;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.component.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record CapturedBlock(BlockState blockState, Optional<CompoundTag> serializedBE, ItemStack itemStack) {
    public static final CapturedBlock EMPTY = new CapturedBlock(Blocks.AIR.defaultBlockState(), Optional.empty(), ItemStack.EMPTY);
    public static final Codec<CapturedBlock> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.CODEC.fieldOf("state").forGetter(CapturedBlock::blockState), (App)CompoundTag.CODEC.optionalFieldOf("entity").forGetter(CapturedBlock::serializedBE), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(CapturedBlock::itemStack)).apply((Applicative)builder, CapturedBlock::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CapturedBlock> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), CapturedBlock::blockState, (StreamCodec)ByteBufCodecs.OPTIONAL_COMPOUND_TAG, CapturedBlock::serializedBE, (StreamCodec)ItemStack.STREAM_CODEC, CapturedBlock::itemStack, CapturedBlock::new);

    public CapturedBlock(BlockState blockState, @Nullable BlockEntity blockEntity, HolderLookup.Provider provider, ItemStack itemStack) {
        this(blockState, blockEntity == null ? Optional.empty() : Optional.of(blockEntity.saveWithId(provider)), itemStack);
    }

    public CapturedBlock applyRotationMirror(RotationMirror rotationMirror, Level level) {
        if (this.serializedBE.isEmpty()) {
            return new CapturedBlock(rotationMirror.applyToBlockState(this.blockState), this.serializedBE, this.itemStack);
        }
        Blueprint blueprint = new Blueprint(1, 1, 1, (HolderLookup.Provider)level.registryAccess());
        blueprint.addBlockState(BlockPos.ZERO, this.blockState);
        blueprint.getTileEntities()[0][0][0] = this.serializedBE.get();
        blueprint.setCachePrimaryOffset(BlockPos.ZERO);
        blueprint.setRotationMirrorRelative(rotationMirror, level);
        return new CapturedBlock(blueprint.getPalette()[blueprint.getPalleteSize()], Optional.of(blueprint.getTileEntities()[0][0][0]), this.itemStack);
    }

    public boolean hasBlockEntity() {
        return this.serializedBE.isPresent() && !this.serializedBE.get().isEmpty();
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.CAPTURED_BLOCK, (Object)this);
    }

    public static CapturedBlock readFromItemStack(ItemStack itemStack) {
        return (CapturedBlock)itemStack.getOrDefault(ModDataComponents.CAPTURED_BLOCK, (Object)EMPTY);
    }

    public static void updateItemStack(ItemStack itemStack, UnaryOperator<CapturedBlock> updater) {
        ((CapturedBlock)updater.apply(CapturedBlock.readFromItemStack(itemStack))).writeToItemStack(itemStack);
    }
}

