/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.api.constants.Constants;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.INamedBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IRequirementsBlueprintAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.client.gui.AbstractBlueprintManipulationWindow;
import com.ldtteam.structurize.client.gui.WindowSwitchPack;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToServer;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class WindowExtendedBuildTool
extends AbstractBlueprintManipulationWindow {
    public static final Predicate<Blueprint> BLOCK_BLUEPRINT_REQUIREMENT = blueprint -> {
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        Block patt0$temp = anchor.getBlock();
        if (patt0$temp instanceof IRequirementsBlueprintAnchorBlock) {
            IRequirementsBlueprintAnchorBlock requirements = (IRequirementsBlueprintAnchorBlock)patt0$temp;
            return requirements.areRequirementsMet(Minecraft.getInstance().level, RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getPos(), Minecraft.getInstance().player);
        }
        return true;
    };
    private ScrollingList folderList;
    private ScrollingList blueprintList;
    private ScrollingList alternativesList;
    private ScrollingList levelsList;
    private static StructurePackMeta structurePack = null;
    private static String nextDepth = "";
    private static String depth = "";
    private static Future<List<StructurePacks.Category>> categoryFutures = null;
    private static final Map<String, Future<List<StructurePacks.Category>>> nextDepthMeta = new LinkedHashMap<String, Future<List<StructurePacks.Category>>>();
    private static final Map<String, Future<List<Blueprint>>> blueprintsAtDepth = new LinkedHashMap<String, Future<List<Blueprint>>>();
    private static final Map<String, Map<String, Map<String, List<Blueprint>>>> currentBluePrintMappingAtDepthCache = new LinkedHashMap<String, Map<String, Map<String, List<Blueprint>>>>();
    private static String currentBlueprintCat = "";
    private final BiConsumer<WindowExtendedBuildTool, Blueprint> selectionCallback;
    public Blueprint selectedBlueprint = null;
    private final Predicate<Blueprint> availableBlueprintPredicate;
    private final HolderLookup.Provider provider;

    public WindowExtendedBuildTool(BlockPos pos, int groundstyle, HolderLookup.Provider provider) {
        this(pos, groundstyle, null, BLOCK_BLUEPRINT_REQUIREMENT, provider);
    }

    public WindowExtendedBuildTool(BlockPos pos, int groundstyle, @Nullable BiConsumer<WindowExtendedBuildTool, Blueprint> selectionCallback, @Nullable Predicate<Blueprint> availableBlueprintPredicate, HolderLookup.Provider provider) {
        super("structurize:gui/windowbuildtool.xml", pos, groundstyle, "blueprint");
        this.selectionCallback = selectionCallback;
        this.availableBlueprintPredicate = availableBlueprintPredicate;
        this.provider = provider;
        this.init(groundstyle, pos);
    }

    @Override
    protected void confirmClicked() {
        if (this.selectionCallback == null) {
            super.confirmClicked();
            return;
        }
        this.selectionCallback.accept(this, this.selectedBlueprint);
    }

    private void init(int groundstyle, BlockPos pos) {
        this.groundstyle = groundstyle;
        if (StructurePacks.selectedPack == null) {
            if (StructurePacks.getPackMetas().isEmpty()) {
                return;
            }
            StructurePacks.selectedPack = StructurePacks.getPackMetas().iterator().next();
        }
        if (structurePack != null && !structurePack.getName().equals(StructurePacks.selectedPack.getName())) {
            depth = "";
            currentBluePrintMappingAtDepthCache.clear();
            blueprintsAtDepth.clear();
            nextDepthMeta.clear();
            categoryFutures = null;
            nextDepth = "";
            currentBlueprintCat = "";
            RenderingCache.removeBlueprint("blueprint");
            if (pos != null && RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getPos() == null) {
                RenderingCache.getOrCreateBlueprintPreviewData("blueprint").setPos(pos);
                this.adjustToGroundOffset();
            }
        }
        structurePack = StructurePacks.selectedPack;
        this.registerButton("switch", this::switchPackClicked);
        this.folderList = (ScrollingList)this.findPaneOfTypeByID("subcategories", ScrollingList.class);
        this.blueprintList = (ScrollingList)this.findPaneOfTypeByID("blueprints", ScrollingList.class);
        this.alternativesList = (ScrollingList)this.findPaneOfTypeByID("alternatives", ScrollingList.class);
        this.levelsList = (ScrollingList)this.findPaneOfTypeByID("levels", ScrollingList.class);
        if (depth.isEmpty()) {
            ((Text)this.findPaneOfTypeByID("tree", Text.class)).setText(Component.literal((String)structurePack.getName()).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        } else {
            ((Text)this.findPaneOfTypeByID("tree", Text.class)).setText(Component.literal((String)(structurePack.getName() + "/" + depth + (String)(RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint() == null ? "" : "/" + RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint().getFileName()))).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        }
        categoryFutures = StructurePacks.getCategoriesFuture(structurePack.getName(), "");
        ((View)this.findPaneOfTypeByID("manipulator", View.class)).setVisible(RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint() != null);
        if (!currentBlueprintCat.isEmpty()) {
            String up = currentBlueprintCat.substring(0, currentBlueprintCat.lastIndexOf(":"));
            this.handleBlueprintCategory(up.contains(":") ? up : currentBlueprintCat, true);
        }
        this.updateRotationState();
    }

    @Override
    public void onOpened() {
        if (structurePack == null) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.pack.none"), false);
            this.close();
            return;
        }
        super.onOpened();
    }

    private void switchPackClicked() {
        new WindowSwitchPack(() -> new WindowExtendedBuildTool(RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getPos(), this.groundstyle, this.selectionCallback, this.availableBlueprintPredicate, this.provider)).open();
    }

    @Override
    protected void cancelClicked() {
        BlueprintPreviewData previewData = RenderingCache.removeBlueprint("blueprint");
        previewData.setBlueprint(null);
        previewData.setPos(BlockPos.ZERO);
        new SyncPreviewCacheToServer(previewData).sendToServer();
        this.close();
        currentBlueprintCat = "";
        depth = "";
    }

    @Override
    protected void hideOtherGuiForPlacement() {
        super.hideOtherGuiForPlacement();
        this.blueprintList.disable();
        this.blueprintList.hide();
        this.folderList.hide();
        this.folderList.disable();
        this.alternativesList.hide();
        this.alternativesList.disable();
        this.levelsList.hide();
        this.levelsList.disable();
    }

    @Override
    protected void handlePlacement(BuildToolPlacementMessage.HandlerType type, String id) {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData("blueprint");
        if (previewData.getBlueprint() != null) {
            new BuildToolPlacementMessage(type, id, structurePack.getName(), structurePack.getSubPath(previewData.getBlueprint().getFilePath().resolve(previewData.getBlueprint().getFileName() + ".blueprint")), previewData.getPos(), previewData.getRotationMirror()).sendToServer();
            if (type == BuildToolPlacementMessage.HandlerType.Survival) {
                this.cancelClicked();
            }
        }
    }

    @Override
    public void onUpdate() {
        block22: {
            Future<List<Blueprint>> blueprints;
            super.onUpdate();
            if (categoryFutures != null && categoryFutures.isDone()) {
                View categoryView = (View)this.findPaneOfTypeByID("categories", View.class);
                if (!categoryView.getChildren().isEmpty()) {
                    categoryView.getChildren().clear();
                }
                try {
                    int index = 0;
                    for (StructurePacks.Category category : categoryFutures.get()) {
                        ButtonImage img = new ButtonImage();
                        if (category.hasIcon) {
                            try {
                                img.setImage((ResourceLocation)OutOfJarResourceLocation.of((String)"structurize", (Path)category.packMeta.getPath().resolve(category.subPath).resolve("icon.png")));
                                img.setImageDisabled((ResourceLocation)OutOfJarResourceLocation.of((String)"structurize", (Path)category.packMeta.getPath().resolve(category.subPath).resolve("icon_disabled.png")));
                            }
                            catch (Exception ex) {
                                img.setImage(Constants.resLocStruct("textures/gui/buildtool/default.png"));
                            }
                        } else {
                            img.setImage(Constants.resLocStruct("textures/gui/buildtool/default.png"));
                        }
                        String id = category.subPath;
                        img.setSize(19, 19);
                        img.setPosition(index * 20, 0);
                        img.setID(id);
                        categoryView.addChild((Pane)img);
                        PaneBuilders.tooltipBuilder().hoverPane((Pane)img).build().setText(Component.literal((String)(id.substring(0, 1).toUpperCase(Locale.US) + id.substring(1))));
                        if (category.isTerminal) {
                            blueprintsAtDepth.put(id, StructurePacks.getBlueprintsFuture(structurePack.getName(), id, this.provider));
                        } else {
                            nextDepthMeta.put(id, StructurePacks.getCategoriesFuture(structurePack.getName(), id));
                        }
                        ++index;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                categoryFutures = null;
            }
            if (!nextDepth.isEmpty() && nextDepthMeta.containsKey(nextDepth)) {
                Future<List<StructurePacks.Category>> subCategories = nextDepthMeta.get(nextDepth);
                if (subCategories.isDone()) {
                    try {
                        List<StructurePacks.Category> subCats = subCategories.get();
                        if (subCats.isEmpty()) {
                            nextDepthMeta.remove(nextDepth);
                            blueprintsAtDepth.put(nextDepth, StructurePacks.getBlueprintsFuture(this.id, nextDepth, this.provider));
                            break block22;
                        }
                        for (StructurePacks.Category subCat : subCats) {
                            String id = subCat.subPath;
                            if (subCat.isTerminal) {
                                blueprintsAtDepth.put(id, StructurePacks.getBlueprintsFuture(structurePack.getName(), id, this.provider));
                                continue;
                            }
                            nextDepthMeta.put(id, StructurePacks.getCategoriesFuture(structurePack.getName(), id));
                        }
                        this.updateFolders(subCats, null);
                        nextDepth = "";
                    }
                    catch (Exception ex) {
                        Log.getLogger().error("Something happened when loading subcategories", (Throwable)ex);
                    }
                }
            } else if (!nextDepth.isEmpty() && blueprintsAtDepth.containsKey(nextDepth) && (blueprints = blueprintsAtDepth.get(nextDepth)).isDone()) {
                try {
                    this.updateBlueprints(blueprints.get(), nextDepth);
                    nextDepth = "";
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void settingsClicked() {
        super.settingsClicked();
        this.folderList.disable();
        this.folderList.hide();
        this.blueprintList.disable();
        this.blueprintList.hide();
        View categories = (View)this.findPaneOfTypeByID("categories", View.class);
        if (this.settingsList.isVisible()) {
            categories.off();
        } else {
            categories.on();
            for (Pane pane : categories.getChildren()) {
                pane.enable();
            }
        }
    }

    public void updateFolders(List<StructurePacks.Category> inputCategories, String prevCat) {
        this.folderList.enable();
        this.folderList.show();
        this.blueprintList.disable();
        this.blueprintList.hide();
        this.hidePlacementGui();
        final ArrayList<ButtonData> categories = new ArrayList<ButtonData>();
        if (!inputCategories.isEmpty()) {
            String parentCat = "";
            if (nextDepth.contains("/")) {
                String[] split = nextDepth.split("/");
                String currentCat = split[split.length - 1].equals("") ? split[split.length - 2] : split[split.length - 1];
                parentCat = nextDepth.replace("/" + currentCat, "");
            }
            categories.add(new ButtonData(ButtonType.Back, parentCat));
        } else if (prevCat != null) {
            categories.add(new ButtonData(ButtonType.Back, prevCat));
        }
        for (StructurePacks.Category category : inputCategories) {
            categories.add(new ButtonData(ButtonType.SubCategory, category));
        }
        if (categories.size() <= 3) {
            this.folderList.setSize(270, 20);
            this.folderList.setPosition(100, 180);
        } else if (categories.size() > 6) {
            this.folderList.setSize(270, 60);
            this.folderList.setPosition(100, 140);
        } else {
            this.folderList.setSize(270, 40);
            this.folderList.setPosition(100, 160);
        }
        this.folderList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return (int)Math.ceil((double)categories.size() / 3.0);
            }

            public void updateElement(int index, Pane rowPane) {
                for (int i = 1; i <= 3; ++i) {
                    int catIndex = index * 3 + i - 1;
                    if (categories.size() <= catIndex) continue;
                    WindowExtendedBuildTool.this.handleSubCat((ButtonData)categories.get(catIndex), rowPane, i);
                }
            }
        });
    }

    public void updateBlueprints(List<Blueprint> inputBluePrints, final String depth) {
        this.blueprintList.enable();
        this.blueprintList.show();
        this.folderList.disable();
        this.folderList.hide();
        this.hidePlacementGui();
        final ArrayList<ButtonData> blueprints = new ArrayList<ButtonData>();
        if (!inputBluePrints.isEmpty()) {
            String parentCat = "";
            if (depth.contains("/")) {
                String[] split = depth.split("/");
                String currentCat = split[split.length - 1].equals("") ? split[split.length - 2] : split[split.length - 1];
                parentCat = depth.replace("/" + currentCat, "");
            }
            blueprints.add(new ButtonData(ButtonType.Back, parentCat));
        }
        LinkedHashMap<String, List> blueprintMapping = new LinkedHashMap<String, List>();
        for (Blueprint blueprint : inputBluePrints) {
            String name;
            BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
            if (!Minecraft.getInstance().player.isCreative() && BlueprintTagUtils.isInvisible(blueprint)) continue;
            Block block = anchor.getBlock();
            if (block instanceof ILeveledBlueprintAnchorBlock) {
                ILeveledBlueprintAnchorBlock leveledAnchor = (ILeveledBlueprintAnchorBlock)block;
                int level = leveledAnchor.getLevel(blueprint.getTileEntityData(RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getPos(), blueprint.getPrimaryBlockOffset()));
                String tempName = this.getCustomName(blueprint, blueprint.getFileName().replace(Integer.toString(level), ""));
                name = tempName.isEmpty() ? this.getCustomName(blueprint, blueprint.getFileName()) : tempName;
            } else {
                name = this.getCustomName(blueprint, blueprint.getFileName());
            }
            List blueprintList = blueprintMapping.getOrDefault(name, new ArrayList());
            blueprintList.add(blueprint);
            blueprintMapping.put(name, blueprintList);
        }
        LinkedHashMap<String, Map> altBlueprintMapping = new LinkedHashMap<String, Map>();
        for (Map.Entry entry : blueprintMapping.entrySet()) {
            Blueprint blueprint = (Blueprint)((List)entry.getValue()).get(0);
            BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
            String name = anchor.getBlock() instanceof INamedBlueprintAnchorBlock ? anchor.getBlock().getDescriptionId() : (String)entry.getKey();
            Map tempLeveledBlueprints = altBlueprintMapping.getOrDefault(name, new LinkedHashMap());
            tempLeveledBlueprints.put((String)entry.getKey(), (List)entry.getValue());
            altBlueprintMapping.put(name, tempLeveledBlueprints);
        }
        currentBluePrintMappingAtDepthCache.put(depth, altBlueprintMapping);
        for (Map.Entry entry : altBlueprintMapping.entrySet()) {
            blueprints.add(new ButtonData(ButtonType.Blueprint, entry.getKey()));
        }
        if (blueprints.size() <= 3) {
            this.blueprintList.setSize(270, 20);
            this.blueprintList.setPosition(100, 180);
        } else if (blueprints.size() > 6) {
            this.blueprintList.setSize(270, 60);
            this.blueprintList.setPosition(100, 140);
        } else {
            this.blueprintList.setSize(270, 40);
            this.blueprintList.setPosition(100, 160);
        }
        this.blueprintList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return (int)Math.ceil((double)blueprints.size() / 3.0);
            }

            public void updateElement(int index, Pane rowPane) {
                for (int i = 1; i <= 3; ++i) {
                    int catIndex = index * 3 + i - 1;
                    if (blueprints.size() <= catIndex) continue;
                    WindowExtendedBuildTool.this.handleBlueprint((ButtonData)blueprints.get(catIndex), rowPane, i, depth);
                }
            }
        });
    }

    public void updateAlternatives(Map<String, List<Blueprint>> bluePrintMapping, final String depth) {
        this.alternativesList.enable();
        this.alternativesList.show();
        this.levelsList.hide();
        this.levelsList.disable();
        this.settingsList.hide();
        this.settingsList.disable();
        final ArrayList<Map.Entry<String, List<Blueprint>>> list = new ArrayList<Map.Entry<String, List<Blueprint>>>(bluePrintMapping.entrySet());
        this.alternativesList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return list.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ButtonImage button = (ButtonImage)rowPane.findPaneOfTypeByID("alternative", ButtonImage.class);
                ((Text)rowPane.findPaneOfTypeByID("id", Text.class)).setText(Component.literal((String)(depth + ":" + (String)((Map.Entry)list.get(index)).getKey())));
                button.setText(Component.literal((String)((String)((Map.Entry)list.get(index)).getKey())));
                button.setTextColor(ChatFormatting.BLACK.getColor().intValue());
            }
        });
    }

    public void updateLevels(final List<Blueprint> blueprints, final String depth, final boolean hasAlternatives) {
        this.levelsList.enable();
        this.levelsList.show();
        this.alternativesList.hide();
        this.alternativesList.disable();
        this.settingsList.hide();
        this.settingsList.disable();
        if (hasAlternatives) {
            blueprints.add(0, null);
        }
        this.levelsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return blueprints.size();
            }

            public void updateElement(int index, Pane rowPane) {
                if (blueprints.get(index) == null) {
                    String buttonId = depth.substring(0, depth.lastIndexOf(":")) + ":$back";
                    ButtonImage button = (ButtonImage)rowPane.findPaneOfTypeByID("level", ButtonImage.class);
                    ((Text)rowPane.findPaneOfTypeByID("id", Text.class)).setText(Component.literal((String)buttonId));
                    button.setText(Component.literal((String)""));
                    button.setImage(Constants.resLocStruct("textures/gui/buildtool/back_medium.png"));
                } else {
                    String buttonId = depth + ":" + (hasAlternatives ? index - 1 : index);
                    ButtonImage button = (ButtonImage)rowPane.findPaneOfTypeByID("level", ButtonImage.class);
                    ((Text)rowPane.findPaneOfTypeByID("id", Text.class)).setText(Component.literal((String)buttonId));
                    button.setImage(Constants.resLocStruct("textures/gui/buildtool/button_medium.png"));
                    button.setText(Component.literal((String)("Level: " + (index + (hasAlternatives ? 0 : 1)))));
                    button.setTextColor(ChatFormatting.BLACK.getColor().intValue());
                }
            }
        });
    }

    private void handleBlueprint(ButtonData buttonData, Pane rowPane, int index, String depth) {
        ButtonImage img = (ButtonImage)rowPane.findPaneOfTypeByID(Integer.toString(index), ButtonImage.class);
        if (buttonData.type == ButtonType.Back) {
            if (img == null) {
                img = (ButtonImage)rowPane.findPaneOfTypeByID("$back:" + String.valueOf(buttonData.data), ButtonImage.class);
            }
            img.setID("$back:" + String.valueOf(buttonData.data));
            img.setVisible(true);
            img.setImage(Constants.resLocStruct("textures/gui/buildtool/back_medium.png"));
            PaneBuilders.tooltipBuilder().hoverPane((Pane)img).build().setText(Component.literal((String)"back"));
        } else if (buttonData.type == ButtonType.Blueprint) {
            String id = (String)buttonData.data;
            if (img == null) {
                img = (ButtonImage)rowPane.findPaneOfTypeByID(depth + ":" + id, ButtonImage.class);
            }
            if (img == null) {
                return;
            }
            img.setID(depth + ":" + id);
            Map<String, List<Blueprint>> blueprintMap = currentBluePrintMappingAtDepthCache.get(depth).get(id);
            Blueprint firstBlueprint = blueprintMap.values().iterator().next().get(0);
            BlockState anchor = firstBlueprint.getBlockState(firstBlueprint.getPrimaryBlockOffset());
            ArrayList<MutableComponent> toolTip = new ArrayList<MutableComponent>();
            Block block = anchor.getBlock();
            if (block instanceof INamedBlueprintAnchorBlock) {
                INamedBlueprintAnchorBlock namedBlock = (INamedBlueprintAnchorBlock)block;
                img.setText(namedBlock.getBlueprintDisplayName());
                toolTip.addAll(namedBlock.getDesc());
            } else {
                String name = this.getCustomName(firstBlueprint, firstBlueprint.getFileName());
                img.setText(Component.literal((String)name));
                toolTip.add(Component.literal((String)name));
            }
            img.setVisible(true);
            boolean allInvis = true;
            boolean isCurrentlySelected = false;
            for (List<Blueprint> blueprints : blueprintMap.values()) {
                for (Blueprint blueprint : blueprints) {
                    if (!blueprint.equals(RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint())) continue;
                    isCurrentlySelected = true;
                }
                if (BlueprintTagUtils.isInvisible(blueprints.get(0))) continue;
                allInvis = false;
            }
            boolean hasAlts = blueprintMap.values().size() > 1;
            boolean isLocked = false;
            if (this.availableBlueprintPredicate != null && !this.availableBlueprintPredicate.test(firstBlueprint)) {
                Block block2 = anchor.getBlock();
                if (block2 instanceof IRequirementsBlueprintAnchorBlock) {
                    IRequirementsBlueprintAnchorBlock requirements = (IRequirementsBlueprintAnchorBlock)block2;
                    toolTip.addAll(requirements.getRequirements(Minecraft.getInstance().level, RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getPos(), Minecraft.getInstance().player));
                }
                PaneBuilders.tooltipBuilder().hoverPane((Pane)img).build().setText(toolTip);
                img.setImage(Constants.resLocStruct("textures/gui/buildtool/button_blueprint_disabled" + (hasAlts ? "_variant" : "") + ".png"));
                isLocked = true;
            }
            PaneBuilders.tooltipBuilder().hoverPane((Pane)img).build().setText(toolTip);
            if (isCurrentlySelected) {
                img.setImage(Constants.resLocStruct("textures/gui/buildtool/button_blueprint_selected" + (allInvis ? "_creative" : "") + (hasAlts ? "_variant" : "") + ".png"));
            } else if (!isLocked) {
                img.setImage(Constants.resLocStruct("textures/gui/buildtool/button_blueprint" + (allInvis ? "_creative" : "") + (hasAlts ? "_variant" : "") + ".png"));
            }
        }
    }

    private String getCustomName(Blueprint blueprint, String defaultName) {
        Map<BlockPos, List<String>> tagPosMap = BlueprintTagUtils.getBlueprintTags(blueprint);
        Optional<String> nameTag = ((List)tagPosMap.getOrDefault(BlockPos.ZERO, new ArrayList())).stream().filter(t -> t.startsWith("name=")).findFirst();
        return nameTag.map(s -> s.substring(5)).orElse(defaultName);
    }

    private void handleSubCat(ButtonData buttonData, Pane rowPane, int index) {
        ButtonImage img = (ButtonImage)rowPane.findPaneOfTypeByID(Integer.toString(index), ButtonImage.class);
        if (buttonData.type == ButtonType.Back) {
            if (img == null) {
                img = (ButtonImage)rowPane.findPaneOfTypeByID("$back:" + String.valueOf(buttonData.data), ButtonImage.class);
            }
            img.setID("$back:" + String.valueOf(buttonData.data));
            img.setVisible(true);
            img.setImage(Constants.resLocStruct("textures/gui/buildtool/back_medium.png"));
            PaneBuilders.tooltipBuilder().hoverPane((Pane)img).build().setText(Component.literal((String)"back"));
            return;
        }
        StructurePacks.Category subCat = (StructurePacks.Category)buttonData.data;
        String id = subCat.subPath;
        if (img == null) {
            img = (ButtonImage)rowPane.findPaneOfTypeByID(id, ButtonImage.class);
        }
        img.setID(id);
        Object descString = id.split("/")[id.split("/").length - 1];
        descString = ((String)descString).substring(0, 1).toUpperCase(Locale.US) + ((String)descString).substring(1);
        MutableComponent desc = Component.literal((String)descString);
        img.setText((Component)desc);
        img.setVisible(true);
        img.setTextColor(ChatFormatting.BLACK.getColor().intValue());
    }

    @Override
    public void onButtonClicked(Button button) {
        boolean handled = false;
        if (button.getID().contains("$back:")) {
            nextDepth = button.getID().split(":").length == 1 ? "" : button.getID().split(":")[1];
            this.updateFolders(Collections.emptyList(), null);
            this.updateBlueprints(Collections.emptyList(), "");
            depth = nextDepth;
            if (depth.isEmpty()) {
                for (Pane pane : ((View)this.findPaneOfTypeByID("categories", View.class)).getChildren()) {
                    pane.enable();
                }
            }
            ((Text)this.findPaneOfTypeByID("tree", Text.class)).setText(Component.literal((String)(structurePack.getName() + "/" + nextDepth)).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
            button.setHoverPane(null);
            handled = true;
        } else if (nextDepthMeta.containsKey(button.getID())) {
            nextDepth = button.getID();
            this.updateFolders(Collections.emptyList(), null);
            this.updateBlueprints(Collections.emptyList(), "");
            depth = nextDepth;
            ((Text)this.findPaneOfTypeByID("tree", Text.class)).setText(Component.literal((String)(structurePack.getName() + "/" + nextDepth)).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
            if (nextDepth.contains("/")) {
                button.setHoverPane(null);
            } else {
                for (Pane pane : ((View)this.findPaneOfTypeByID("categories", View.class)).getChildren()) {
                    pane.enable();
                }
                button.disable();
            }
            handled = true;
        } else if (blueprintsAtDepth.containsKey(button.getID())) {
            nextDepth = button.getID();
            this.updateFolders(Collections.emptyList(), null);
            this.updateBlueprints(Collections.emptyList(), "");
            depth = nextDepth;
            ((Text)this.findPaneOfTypeByID("tree", Text.class)).setText(Component.literal((String)(structurePack.getName() + "/" + nextDepth)).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
            if (nextDepth.contains("/")) {
                button.setHoverPane(null);
            } else {
                for (Pane pane : ((View)this.findPaneOfTypeByID("categories", View.class)).getChildren()) {
                    pane.enable();
                }
                button.disable();
            }
            handled = true;
        } else if (button.getID().contains(":")) {
            for (Pane pane : ((View)this.findPaneOfTypeByID("categories", View.class)).getChildren()) {
                pane.enable();
            }
            currentBlueprintCat = button.getID().replace(":$back", "");
            this.handleBlueprintCategory(currentBlueprintCat, false);
            button.setHoverPane(null);
            handled = true;
        } else if (button.getID().equals("alternative") || button.getID().equals("level")) {
            for (Pane pane : ((View)this.findPaneOfTypeByID("categories", View.class)).getChildren()) {
                pane.enable();
            }
            currentBlueprintCat = ((Text)button.getParent().findPaneOfTypeByID("id", Text.class)).getText().getString().replace(":$back", "");
            this.handleBlueprintCategory(currentBlueprintCat, false);
            button.setHoverPane(null);
            handled = true;
        }
        ((View)this.findPaneOfTypeByID("manipulator", View.class)).setVisible(RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint() != null);
        if (!handled) {
            super.onButtonClicked(button);
        }
    }

    private void handleBlueprintCategory(String categoryId, boolean onOpen) {
        String[] split = categoryId.split(":");
        String id = split[1];
        Map<String, List<Blueprint>> mapping = currentBluePrintMappingAtDepthCache.get(split[0]).get(id);
        if (mapping == null) {
            Log.getLogger().error("Invalid blueprint name at depth: " + categoryId);
            return;
        }
        if (split.length == 2) {
            if (mapping.size() == 1 && mapping.values().iterator().next().size() == 1) {
                this.alternativesList.hide();
                this.alternativesList.disable();
                this.levelsList.hide();
                this.levelsList.disable();
                this.setBlueprint(mapping.values().iterator().next().get(0));
                return;
            }
            if (mapping.size() > 1) {
                this.updateLevels(Collections.emptyList(), "", false);
                this.updateAlternatives(mapping, categoryId);
            } else {
                this.updateAlternatives(Collections.emptyMap(), categoryId);
                List<Blueprint> leveled = mapping.values().iterator().next();
                if (RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint() == null || !onOpen) {
                    this.setBlueprint(leveled.get(0));
                }
                this.updateLevels(leveled, categoryId + ":" + mapping.keySet().iterator().next(), false);
            }
        } else if (split.length == 3) {
            List<Blueprint> list = mapping.get(split[2]);
            if (list == null || list.isEmpty()) {
                Log.getLogger().error("Invalid blueprint name at depth: " + categoryId);
                return;
            }
            if (RenderingCache.getOrCreateBlueprintPreviewData("blueprint").getBlueprint() == null || list.size() == 1 || !onOpen) {
                this.setBlueprint(list.get(0));
            }
            if (list.size() == 1) {
                return;
            }
            this.updateAlternatives(Collections.emptyMap(), categoryId);
            this.updateLevels(new ArrayList<Blueprint>(list), categoryId, mapping.size() > 1);
        } else if (split.length == 4) {
            List<Blueprint> list = mapping.get(split[2]);
            if (list == null || list.isEmpty()) {
                Log.getLogger().error("Invalid blueprint name at depth: " + categoryId);
                return;
            }
            try {
                int level = Integer.parseInt(split[3]);
                this.setBlueprint(list.get(level));
                return;
            }
            catch (NumberFormatException exception) {
                Log.getLogger().error("Invalid blueprint name at depth: " + categoryId);
            }
        } else {
            Log.getLogger().error("Invalid blueprint name at depth: " + categoryId);
        }
        this.updateFolders(Collections.emptyList(), split[0]);
    }

    private void setBlueprint(Blueprint blueprint) {
        BlueprintPreviewData data = RenderingCache.getOrCreateBlueprintPreviewData("blueprint");
        ((Text)this.findPaneOfTypeByID("tree", Text.class)).setText(Component.literal((String)(structurePack.getName() + "/" + depth + "/" + blueprint.getFileName())).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
        data.setBlueprint(blueprint);
        this.adjustToGroundOffset();
        this.selectedBlueprint = blueprint;
        boolean canBuild = this.availableBlueprintPredicate == null || this.availableBlueprintPredicate.test(blueprint);
        ((Button)this.findPaneOfTypeByID("confirm", Button.class)).setVisible(canBuild);
    }

    public static void clearStaticData() {
        nextDepthMeta.clear();
        blueprintsAtDepth.clear();
        currentBluePrintMappingAtDepthCache.clear();
    }

    public static class ButtonData {
        public ButtonType type;
        public Object data;

        public ButtonData(ButtonType type, Object data) {
            this.type = type;
            this.data = data;
        }
    }

    public static enum ButtonType {
        Blueprint,
        SubCategory,
        Back;

    }
}

