/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.fakelevel;

import com.ldtteam.common.fakelevel.FakeLevel;
import com.ldtteam.common.fakelevel.IFakeLevelBlockGetter;
import com.ldtteam.common.fakelevel.IFakeLevelLightProvider;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.util.BlockUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.Scoreboard;

public class BlueprintBlockAccess
extends FakeLevel<Blueprint> {
    public static final IFakeLevelLightProvider LIGHT_PROVIDER = new IFakeLevelLightProvider.ConfigBasedLightProvider(((ClientConfiguration)Structurize.getConfig().getClient()).rendererLightLevel);
    private static final Scoreboard SCOREBOARD = new Scoreboard();

    public BlueprintBlockAccess(Blueprint blueprint) {
        super((IFakeLevelBlockGetter)blueprint, LIGHT_PROVIDER, (Level)Minecraft.getInstance().level, SCOREBOARD, true);
    }

    private static Level anyLevel() {
        Minecraft mc = Minecraft.getInstance();
        return mc.hasSingleplayerServer() ? mc.getSingleplayerServer().getPlayerList().getPlayer(mc.player.getUUID()).level() : mc.level;
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.prepareBlockStateForRendering(super.getBlockState(pos), pos);
    }

    public BlockState prepareBlockStateForRendering(BlockState state, BlockPos pos) {
        if (((Boolean)((ClientConfiguration)Structurize.getConfig().getClient()).renderPlaceholdersNice.get()).booleanValue()) {
            if (state.getBlock() == ModBlocks.blockSolidSubstitution.get()) {
                return BlockUtils.getSubstitutionBlockAtWorld(BlueprintBlockAccess.anyLevel(), this.worldPos.offset((Vec3i)pos), ((Blueprint)this.levelSource).getRawBlockStateFunction().compose(b -> b.subtract((Vec3i)this.worldPos)));
            }
            if (state.getBlock() == ModBlocks.blockFluidSubstitution.get()) {
                return BlockUtils.getFluidForDimension(BlueprintBlockAccess.anyLevel());
            }
            if (state.getBlock() == ModBlocks.blockSubstitution.get()) {
                return Blocks.AIR.defaultBlockState();
            }
            if (state.getBlock() == ModBlocks.blockTagSubstitution.get()) {
                BlockEntity blockEntity = super.getBlockEntity(pos);
                if (blockEntity instanceof BlockEntityTagSubstitution) {
                    BlockEntityTagSubstitution tag = (BlockEntityTagSubstitution)blockEntity;
                    return tag.getReplacement().blockState();
                }
                return Blocks.AIR.defaultBlockState();
            }
        }
        return state;
    }
}

