/*
 * Decompiled with CFR 0.152.
 */
package uppers.tiles;

import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import uppers.Uppers;
import uppers.blocks.UpperBlock;
import uppers.tiles.IUpper;
import uppers.tiles.InventoryCodeHooksTweaked;

public class UpperBlockEntity
extends RandomizableContainerBlockEntity
implements IUpper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int UPPER_CONTAINER_SIZE = 5;
    private static final int[][] CACHED_SLOTS = new int[54][];
    private NonNullList<ItemStack> items = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private int cooldownTime = -1;
    private long tickedGameTime;
    private Direction facing;

    public UpperBlockEntity(BlockPos pos, BlockState state) {
        super(Uppers.UPPER_TILE.get(), pos, state);
        this.facing = (Direction)state.getValue((Property)UpperBlock.FACING);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
        this.cooldownTime = tag.getInt("TransferCooldown");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
        tag.putInt("TransferCooldown", this.cooldownTime);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), (int)index, (int)count);
    }

    public void setItem(int index, ItemStack stack) {
        this.unpackLootTable(null);
        this.getItems().set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.facing = (Direction)state.getValue((Property)UpperBlock.FACING);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.upper", (Object[])new Object[0]);
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, UpperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.getGameTime();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            UpperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> UpperBlockEntity.suckInItems(level, blockEntity));
        }
    }

    private static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, UpperBlockEntity blockEntity, BooleanSupplier supplier) {
        if (level.isClientSide) {
            return false;
        }
        if (!blockEntity.isOnCooldown() && ((Boolean)state.getValue((Property)UpperBlock.ENABLED)).booleanValue()) {
            boolean flag = false;
            if (!blockEntity.isEmpty()) {
                flag = UpperBlockEntity.ejectItems(level, pos, blockEntity);
            }
            if (!blockEntity.inventoryFull()) {
                flag |= supplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.setCooldown(8);
                UpperBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level level, BlockPos pos, UpperBlockEntity blockEntity) {
        if (InventoryCodeHooksTweaked.insertHook(blockEntity)) {
            return true;
        }
        Container container = UpperBlockEntity.getAttachedContainer(level, pos, blockEntity);
        if (container == null) {
            return false;
        }
        Direction direction = blockEntity.facing.getOpposite();
        if (UpperBlockEntity.isFullContainer(container, direction)) {
            return false;
        }
        for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
            ItemStack itemstack = blockEntity.getItem(i);
            if (itemstack.isEmpty()) continue;
            int j = itemstack.getCount();
            ItemStack itemstack1 = UpperBlockEntity.addItem(blockEntity, container, blockEntity.removeItem(i, 1), direction);
            if (itemstack1.isEmpty()) {
                container.setChanged();
                return true;
            }
            itemstack.setCount(j);
            if (j != 1) continue;
            blockEntity.setItem(i, itemstack);
        }
        return false;
    }

    private static int[] getSlots(Container pContainer, Direction pDirection) {
        if (pContainer instanceof WorldlyContainer) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)pContainer;
            return worldlycontainer.getSlotsForFace(pDirection);
        }
        int i = pContainer.getContainerSize();
        if (i < CACHED_SLOTS.length) {
            int[] aint = CACHED_SLOTS[i];
            if (aint != null) {
                return aint;
            }
            int[] aint1 = UpperBlockEntity.createFlatSlots(i);
            UpperBlockEntity.CACHED_SLOTS[i] = aint1;
            return aint1;
        }
        return UpperBlockEntity.createFlatSlots(i);
    }

    private static int[] createFlatSlots(int pSize) {
        int[] aint = new int[pSize];
        int i = 0;
        while (i < aint.length) {
            aint[i] = i++;
        }
        return aint;
    }

    private static boolean isFullContainer(Container pContainer, Direction pDirection) {
        int[] aint;
        for (int i : aint = UpperBlockEntity.getSlots(pContainer, pDirection)) {
            ItemStack itemstack = pContainer.getItem(i);
            if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean suckInItems(Level level, IUpper upper) {
        boolean flag;
        BlockPos blockpos = BlockPos.containing((double)upper.getLevelX(), (double)(upper.getLevelY() + 1.0), (double)upper.getLevelZ());
        BlockState blockstate = level.getBlockState(blockpos);
        Boolean ret = InventoryCodeHooksTweaked.extractHook(level, upper);
        if (ret != null) {
            return ret;
        }
        Container container = UpperBlockEntity.getSourceContainer(level, upper, blockpos, blockstate);
        if (container != null) {
            Direction direction = Direction.DOWN;
            for (int i : UpperBlockEntity.getSlots(container, direction)) {
                if (!UpperBlockEntity.tryTakeInItemFromSlot(upper, container, i, direction)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = upper.isGridAligned() && blockstate.isCollisionShapeFullBlock((BlockGetter)level, blockpos) && !blockstate.is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
        if (!flag) {
            for (ItemEntity itementity : UpperBlockEntity.getItemsAtAndAbove(level, upper)) {
                if (!UpperBlockEntity.addItem(upper, itementity)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IUpper upper, Container container, int slot, Direction direction) {
        ItemStack itemstack = container.getItem(slot);
        if (!itemstack.isEmpty() && UpperBlockEntity.canTakeItemFromContainer(upper, container, itemstack, slot, direction)) {
            int i = itemstack.getCount();
            ItemStack itemstack1 = UpperBlockEntity.addItem(container, upper, container.removeItem(slot, 1), null);
            if (itemstack1.isEmpty()) {
                container.setChanged();
                return true;
            }
            itemstack.setCount(i);
            if (i == 1) {
                container.setItem(slot, itemstack);
            }
        }
        return false;
    }

    public static boolean addItem(Container destination, ItemEntity entity) {
        boolean flag = false;
        ItemStack itemstack = entity.getItem().copy();
        ItemStack itemstack1 = UpperBlockEntity.addItem(null, destination, itemstack, null);
        if (itemstack1.isEmpty()) {
            flag = true;
            entity.setItem(ItemStack.EMPTY);
            entity.discard();
        } else {
            entity.setItem(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable Container source, Container destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof WorldlyContainer) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)destination;
            if (direction != null) {
                int[] aint = worldlycontainer.getSlotsForFace(direction);
                for (int k = 0; k < aint.length && !stack.isEmpty(); ++k) {
                    stack = UpperBlockEntity.tryMoveInItem(source, destination, stack, aint[k], direction);
                }
                return stack;
            }
        }
        int i = destination.getContainerSize();
        for (int j = 0; j < i && !stack.isEmpty(); ++j) {
            stack = UpperBlockEntity.tryMoveInItem(source, destination, stack, j, direction);
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container inventoryIn, ItemStack stack, int slot, @Nullable Direction side) {
        WorldlyContainer worldlycontainer;
        if (!inventoryIn.canPlaceItem(slot, stack)) {
            return false;
        }
        return !(inventoryIn instanceof WorldlyContainer) || (worldlycontainer = (WorldlyContainer)inventoryIn).canPlaceItemThroughFace(slot, stack, side);
    }

    private static boolean canTakeItemFromContainer(Container source, Container destination, ItemStack stack, int slot, Direction direction) {
        WorldlyContainer worldlycontainer;
        if (!destination.canTakeItem(source, slot, stack)) {
            return false;
        }
        return !(destination instanceof WorldlyContainer) || (worldlycontainer = (WorldlyContainer)destination).canTakeItemThroughFace(slot, stack, direction);
    }

    private static ItemStack tryMoveInItem(@Nullable Container source, Container destination, ItemStack stack, int slot, @Nullable Direction direction) {
        ItemStack itemstack = destination.getItem(slot);
        if (UpperBlockEntity.canPlaceItemInContainer(destination, stack, slot, direction)) {
            boolean flag = false;
            boolean flag1 = destination.isEmpty();
            if (itemstack.isEmpty()) {
                destination.setItem(slot, stack);
                stack = ItemStack.EMPTY;
                flag = true;
            } else if (UpperBlockEntity.canMergeItems(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemstack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                UpperBlockEntity upperblockentity1;
                if (flag1 && destination instanceof UpperBlockEntity && !(upperblockentity1 = (UpperBlockEntity)destination).isOnCustomCooldown()) {
                    int k = 0;
                    if (source instanceof UpperBlockEntity) {
                        UpperBlockEntity upperblockentity = (UpperBlockEntity)source;
                        if (upperblockentity1.tickedGameTime >= upperblockentity.tickedGameTime) {
                            k = 1;
                        }
                    }
                    upperblockentity1.setCooldown(8 - k);
                }
                destination.setChanged();
            }
        }
        return stack;
    }

    @Nullable
    private static Container getAttachedContainer(Level level, BlockPos pos, UpperBlockEntity blockEntity) {
        return UpperBlockEntity.getContainerAt(level, pos.relative(blockEntity.facing));
    }

    public static Container getSourceContainer(Level level, IUpper upper, BlockPos pos, BlockState state) {
        return UpperBlockEntity.getContainerAt(level, pos, state, upper.getLevelX(), upper.getLevelY() - 1.0, upper.getLevelZ());
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level pLevel, IUpper upper) {
        AABB aabb = upper.getSuckAabb().move(upper.getLevelX() - 0.5, upper.getLevelY() - 0.5, upper.getLevelZ() - 0.5);
        return pLevel.getEntitiesOfClass(ItemEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
    }

    @Nullable
    public static Container getContainerAt(Level level, BlockPos pos) {
        return UpperBlockEntity.getContainerAt(level, pos, level.getBlockState(pos), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    @Nullable
    private static Container getContainerAt(Level level, BlockPos pos, BlockState state, double x, double y, double z) {
        Container container = UpperBlockEntity.getBlockContainer(level, pos, state);
        if (container == null) {
            container = UpperBlockEntity.getEntityContainer(level, x, y, z);
        }
        return container;
    }

    @Nullable
    private static Container getBlockContainer(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        Block block = state.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            return ((WorldlyContainerHolder)block).getContainer(state, (LevelAccessor)level, pos);
        }
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) instanceof Container) {
            Container container = (Container)blockEntity;
            if (container instanceof ChestBlockEntity && block instanceof ChestBlock) {
                container = ChestBlock.getContainer((ChestBlock)((ChestBlock)block), (BlockState)state, (Level)level, (BlockPos)pos, (boolean)true);
            }
            return container;
        }
        return null;
    }

    @Nullable
    private static Container getEntityContainer(Level level, double x, double y, double z) {
        List list = level.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR);
        return !list.isEmpty() ? (Container)list.get(level.random.nextInt(list.size())) : null;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        return stack1.getCount() <= stack1.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    @Override
    public boolean isGridAligned() {
        return true;
    }

    public void setCooldown(int ticks) {
        this.cooldownTime = ticks;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new HopperMenu(id, inventory, (Container)this);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public static void entityInside(Level level, BlockPos pos, BlockState state, Entity entity, UpperBlockEntity blockEntity) {
        ItemEntity itementity;
        if (entity instanceof ItemEntity && !(itementity = (ItemEntity)entity).getItem().isEmpty() && entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())).intersects(blockEntity.getSuckAabb())) {
            UpperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> UpperBlockEntity.addItem(blockEntity, itementity));
        }
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

