/*
 * Decompiled with CFR 0.152.
 */
package uppers.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import uppers.Uppers;
import uppers.tiles.UpperBlockEntity;

public class UpperBlock
extends BaseEntityBlock {
    public static final MapCodec<UpperBlock> CODEC = UpperBlock.simpleCodec(UpperBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    private static final VoxelShape INPUT_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.or((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape INSIDE_BOWL_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    private static final VoxelShape BASE = Shapes.join((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)INSIDE_BOWL_SHAPE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)12.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)12.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)12.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = INSIDE_BOWL_SHAPE;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE_BOWL_SHAPE, (VoxelShape)Block.box((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE_BOWL_SHAPE, (VoxelShape)Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE_BOWL_SHAPE, (VoxelShape)Block.box((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = Shapes.or((VoxelShape)INSIDE_BOWL_SHAPE, (VoxelShape)Block.box((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));

    public UpperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case UP: {
                return DOWN_SHAPE;
            }
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return BASE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case UP: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return INSIDE_BOWL_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.UP : direction))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UpperBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : UpperBlock.createTickerHelper(type, Uppers.UPPER_TILE.get(), UpperBlockEntity::pushItemsTick);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = level.getBlockEntity(pos);
        if (tileentity instanceof UpperBlockEntity) {
            player.openMenu((MenuProvider)((UpperBlockEntity)tileentity));
            player.awardStat(Stats.INSPECT_HOPPER);
        }
        return InteractionResult.CONSUME;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)ENABLED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity instanceof UpperBlockEntity) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)((UpperBlockEntity)tileentity));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ENABLED});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity tileentity = level.getBlockEntity(pos);
        if (tileentity instanceof UpperBlockEntity) {
            UpperBlockEntity.entityInside(level, pos, state, entity, (UpperBlockEntity)tileentity);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected MapCodec<UpperBlock> codec() {
        return CODEC;
    }
}

