/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.common.extensions.IDataComponentHolderExtension;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.inventory.StorageWrapperRepository;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ContentsFilteredItemHandler;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;
import org.jetbrains.annotations.NotNull;

public abstract class MovingStorageWrapper
implements IStorageWrapper {
    private final Runnable stackChangeHandler;
    private final ItemStack storageStack;
    private final Runnable contentsChangeHandler;
    @Nullable
    private InventoryHandler inventoryHandler = null;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    @Nullable
    private SettingsHandler settingsHandler;
    private final RenderInfo renderInfo;
    private final Function<UUID, IStorageSavedData> getStorageData;
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();
    private final Predicate<ItemStack> isUpgradeRunnable;

    private MovingStorageWrapper(ItemStack storageStack, Runnable onContentsChanged, Runnable onStackChanged, Function<UUID, IStorageSavedData> getStorageData, Predicate<ItemStack> isUpgradeRunnable) {
        this.storageStack = storageStack;
        this.contentsChangeHandler = onContentsChanged;
        this.stackChangeHandler = onStackChanged;
        this.renderInfo = new MovingStorageRenderInfo(storageStack);
        this.getStorageData = getStorageData;
        this.isUpgradeRunnable = isUpgradeRunnable;
        if (MovingStorageWrapper.isLimitedBarrel(storageStack)) {
            this.registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, LimitedBarrelBlockEntity.VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
        }
    }

    private static int getNumberOfDisplayItems(ItemStack stack) {
        return stack.getItem() instanceof BarrelBlockItem ? 4 : 1;
    }

    public static MovingStorageWrapper fromStack(ItemStack stack, Runnable onContentsChanged, Runnable onStackChanged, Function<UUID, IStorageSavedData> getStorageData, final BooleanSupplier isLocked, final Consumer<Boolean> setLocked, Predicate<ItemStack> isUpgradeRunnable) {
        MovingStorageWrapper movingStorageWrapper = (MovingStorageWrapper)StorageWrapperRepository.getStorageWrapper((ItemStack)stack, MovingStorageWrapper.class, s -> new MovingStorageWrapper((ItemStack)s, onContentsChanged, onStackChanged, getStorageData, isUpgradeRunnable){

            @Override
            public boolean isLocked() {
                return isLocked.getAsBoolean();
            }

            @Override
            public void setLocked(boolean locked) {
                setLocked.accept(locked);
            }
        });
        UUID uuid = (UUID)stack.get(ModCoreDataComponents.STORAGE_UUID);
        if (uuid != null) {
            movingStorageWrapper.setContentsUuid(uuid);
        }
        return movingStorageWrapper;
    }

    public boolean isUpgradeRunnable(ItemStack upgrade) {
        return this.isUpgradeRunnable.test(upgrade);
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public abstract boolean isLocked();

    public abstract void setLocked(boolean var1);

    public void setContentsChangeHandler(Runnable contentsChangeHandler) {
    }

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContentsNbt(), this.contentsChangeHandler, StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.SERVER.stackUpgrade){

            protected boolean isAllowed(ItemStack stack) {
                return MovingStorageWrapper.this.isAllowedInStorage(stack);
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        this.inventoryHandler.setShouldInsertIntoEmpty(this::emptyInventorySlotsAcceptItems);
        this.inventoryHandler.onInit();
    }

    private boolean emptyInventorySlotsAcceptItems() {
        return !StorageBlockItem.isLocked(this.storageStack) || this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
    }

    private boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return !MovingStorageWrapper.isLimitedBarrel(this.storageStack);
    }

    public int getNumberOfInventorySlots() {
        Integer numberOfInventorySlots = (Integer)this.storageStack.get(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS);
        if (numberOfInventorySlots != null) {
            return numberOfInventorySlots;
        }
        numberOfInventorySlots = MovingStorageWrapper.getDefaultNumberOfInventorySlots(this.storageStack);
        this.storageStack.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)numberOfInventorySlots);
        this.stackChangeHandler.run();
        return numberOfInventorySlots;
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.isLocked() && this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            if (this.contentsFilteredItemHandler == null) {
                this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(this::getInventoryIOHandler, () -> this.getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
            }
            return this.contentsFilteredItemHandler;
        }
        return this.getInventoryIOHandler();
    }

    @NotNull
    private ITrackedContentsItemHandler getInventoryIOHandler() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    public SettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new StorageSettingsHandler(this.getSettingsNbt(), this.contentsChangeHandler, this::getInventoryHandler, () -> this.renderInfo){

                @Override
                protected int getNumberOfDisplayItems() {
                    return MovingStorageWrapper.getNumberOfDisplayItems(MovingStorageWrapper.this.storageStack);
                }

                @Override
                protected void saveCategoryNbt(CompoundTag settingsNbt, String categoryName, CompoundTag tag) {
                    super.saveCategoryNbt(settingsNbt, categoryName, tag);
                    MovingStorageWrapper.this.contentsChangeHandler.run();
                    if (categoryName.equals("item_display")) {
                        MovingStorageWrapper.this.stackChangeHandler.run();
                    }
                }
            } : NoopStorageWrapper.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this, this.getNumberOfUpgradeSlots(), this, this.getContentsNbt(), this.contentsChangeHandler, () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
                ((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return super.isItemValid(slot, stack) && (stack.isEmpty() || stack.is(ModItems.STORAGE_UPGRADE_TAG));
                }
            };
            this.upgradeDefaultsHandlers.forEach(this::registerUpgradeDefaultsHandlerInUpgradeHandler);
        }
        return this.upgradeHandler;
    }

    private <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandlerInUpgradeHandler(Class<T> wrapperClass, Consumer<? extends IUpgradeWrapper> defaultsHandler) {
        this.upgradeHandler.registerUpgradeDefaultsHandler(wrapperClass, defaultsHandler);
    }

    public int getNumberOfUpgradeSlots() {
        Integer numberOfUpgradeSlots = (Integer)this.storageStack.get(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS);
        if (numberOfUpgradeSlots != null) {
            return numberOfUpgradeSlots;
        }
        numberOfUpgradeSlots = MovingStorageWrapper.getDefaultNumberOfUpgradeSlots(this.storageStack);
        this.storageStack.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
        this.stackChangeHandler.run();
        return numberOfUpgradeSlots;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable((UUID)this.storageStack.get(ModCoreDataComponents.STORAGE_UUID));
    }

    private CompoundTag getSettingsNbt() {
        UUID storageId = this.getContentsUuid().orElseGet(this::getNewUuid);
        IStorageSavedData storageData = this.getStorageData.apply(storageId);
        CompoundTag baseContentsNbt = storageData.getContents();
        if (!baseContentsNbt.contains("settings")) {
            baseContentsNbt.put("settings", (Tag)new CompoundTag());
            storageData.setContents(baseContentsNbt);
        }
        return baseContentsNbt.getCompound("settings");
    }

    private CompoundTag getContentsNbt() {
        UUID storageId = this.getContentsUuid().orElseGet(this::getNewUuid);
        IStorageSavedData storageData = this.getStorageData.apply(storageId);
        CompoundTag baseContentsNbt = storageData.getContents();
        if (!baseContentsNbt.contains("contents")) {
            baseContentsNbt.put("contents", (Tag)new CompoundTag());
            storageData.setContents(baseContentsNbt);
        }
        return baseContentsNbt.getCompound("contents");
    }

    public int getMainColor() {
        return StorageBlockItem.getMainColorFromComponentHolder((IDataComponentHolderExtension)this.storageStack).orElse(-1);
    }

    public int getAccentColor() {
        return StorageBlockItem.getAccentColorFromComponentHolder((IDataComponentHolderExtension)this.storageStack).orElse(-1);
    }

    public Optional<Integer> getOpenTabId() {
        return Optional.ofNullable((Integer)this.storageStack.get(ModCoreDataComponents.OPEN_TAB_ID));
    }

    public void setOpenTabId(int openTabId) {
        this.storageStack.set(ModCoreDataComponents.OPEN_TAB_ID, (Object)openTabId);
        this.stackChangeHandler.run();
    }

    public void removeOpenTabId() {
        this.storageStack.remove(ModCoreDataComponents.OPEN_TAB_ID);
        this.stackChangeHandler.run();
    }

    public void setColors(int mainColor, int accentColor) {
        this.storageStack.set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
        this.storageStack.set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
        this.stackChangeHandler.run();
    }

    public void setSortBy(SortBy sortBy) {
        this.storageStack.set(ModCoreDataComponents.SORT_BY, (Object)sortBy);
        this.stackChangeHandler.run();
    }

    public SortBy getSortBy() {
        return (SortBy)this.storageStack.getOrDefault(ModCoreDataComponents.SORT_BY, (Object)SortBy.NAME);
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        slotIndexesExcludedFromSort.addAll(this.getInventoryHandler().getNoSortSlots());
        InventorySorter.sortHandler((IItemHandlerModifiable)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new MatchException(null, null);
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    public void onContentsNbtUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(Player playerEntity) {
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
    }

    public int getColumnsTaken() {
        return 0;
    }

    public void setContentsUuid(UUID contentsUuid) {
        this.storageStack.set(ModCoreDataComponents.STORAGE_UUID, (Object)contentsUuid);
        this.onContentsNbtUpdated();
    }

    public static int getDefaultNumberOfInventorySlots(ItemStack storageStack) {
        int n;
        BlockItemBase blockItem;
        Item item = storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    public static int getDefaultNumberOfUpgradeSlots(ItemStack storageStack) {
        int n;
        BlockItemBase blockItem;
        Item item = storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    private boolean isAllowedInStorage(ItemStack stack) {
        if (!(this.storageStack.getItem() instanceof ShulkerBoxItem)) {
            return true;
        }
        Block block = Block.byItem((Item)stack.getItem());
        return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.getItem());
    }

    public String getStorageType() {
        Item storageItem = this.storageStack.getItem();
        if (!(storageItem instanceof BlockItem)) {
            return "undefined";
        }
        BlockItem blockItem = (BlockItem)storageItem;
        if (blockItem.getBlock() instanceof ChestBlock) {
            return "chest";
        }
        if (blockItem.getBlock() instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) {
            return "shulker_box";
        }
        if (blockItem.getBlock() instanceof LimitedBarrelBlock) {
            return "limited_barrel";
        }
        if (blockItem.getBlock() instanceof BarrelBlock) {
            return "barrel";
        }
        return "undefined";
    }

    public Component getDisplayName() {
        return this.storageStack.getDisplayName();
    }

    public void changeSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        this.setNumberOfInventorySlots(this.getNumberOfInventorySlots() + additionalInventorySlots);
        this.getInventoryHandler().changeSlots(additionalInventorySlots);
        this.setNumberOfUpgradeSlots(this.getNumberOfUpgradeSlots() + additionalUpgradeSlots);
        this.getUpgradeHandler().increaseSize(additionalUpgradeSlots);
    }

    public void setNumberOfInventorySlots(int numberOfInventorySlots) {
        this.storageStack.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)numberOfInventorySlots);
        this.stackChangeHandler.run();
    }

    public void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        this.storageStack.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
        this.stackChangeHandler.run();
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }

    public ItemStack getWrappedStorageStack() {
        return this.storageStack;
    }

    public int getBaseStackSizeMultiplier() {
        int n;
        BlockItem blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getBaseStackSizeMultiplier();
        } else {
            n = 1;
        }
        return n;
    }

    public static boolean isLimitedBarrel(ItemStack storageItem) {
        BlockItem blockItem;
        Item item = storageItem.getItem();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof LimitedBarrelBlock;
    }

    private class MovingStorageRenderInfo
    extends RenderInfo {
        public MovingStorageRenderInfo(ItemStack storageStack) {
            super(() -> net$p3pp3rf1y$sophisticatedstorage$entity$MovingStorageWrapper$this.stackChangeHandler, MovingStorageWrapper.isLimitedBarrel(storageStack));
            this.deserialize();
        }

        protected void serializeRenderInfo(CompoundTag renderInfo) {
            MovingStorageWrapper.this.storageStack.set(ModCoreDataComponents.RENDER_INFO_TAG, (Object)CustomData.of((CompoundTag)renderInfo));
        }

        protected Optional<CompoundTag> getRenderInfoTag() {
            return Optional.ofNullable((CustomData)MovingStorageWrapper.this.storageStack.get((DataComponentType)ModCoreDataComponents.RENDER_INFO_TAG.get())).map(CustomData::copyTag);
        }
    }
}

