/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.SettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.StorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.subtypes.BarrelSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.subtypes.ChestSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.jei.subtypes.ShulkerBoxSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

@JeiPlugin
public class StoragePlugin
implements IModPlugin {
    private static Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar = registration -> {};
    private final PropertyBasedSubtypeInterpreter chestSubtypeInterpreter = new ChestSubtypeInterpreter();
    private final PropertyBasedSubtypeInterpreter barrelSubtypeInterpreter = new BarrelSubtypeInterpreter();
    private final PropertyBasedSubtypeInterpreter shulkerBoxSubtypeInterpreter = new ShulkerBoxSubtypeInterpreter();

    private Map<BlockItem, PropertyBasedSubtypeInterpreter> getSubtypeIntepreters() {
        return new HashMap<BlockItem, PropertyBasedSubtypeInterpreter>(){
            {
                this.put(ModBlocks.BARREL_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.COPPER_BARREL_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.IRON_BARREL_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.GOLD_BARREL_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_BARREL_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_BARREL_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.CHEST_ITEM.get(), StoragePlugin.this.chestSubtypeInterpreter);
                this.put(ModBlocks.COPPER_CHEST_ITEM.get(), StoragePlugin.this.chestSubtypeInterpreter);
                this.put(ModBlocks.IRON_CHEST_ITEM.get(), StoragePlugin.this.chestSubtypeInterpreter);
                this.put(ModBlocks.GOLD_CHEST_ITEM.get(), StoragePlugin.this.chestSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_CHEST_ITEM.get(), StoragePlugin.this.chestSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_CHEST_ITEM.get(), StoragePlugin.this.chestSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_1_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_2_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_3_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_BARREL_4_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get(), StoragePlugin.this.barrelSubtypeInterpreter);
                this.put(ModBlocks.SHULKER_BOX_ITEM.get(), StoragePlugin.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), StoragePlugin.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.IRON_SHULKER_BOX_ITEM.get(), StoragePlugin.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), StoragePlugin.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), StoragePlugin.this.shulkerBoxSubtypeInterpreter);
                this.put(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get(), StoragePlugin.this.shulkerBoxSubtypeInterpreter);
            }
        };
    }

    private Optional<PropertyBasedSubtypeInterpreter> getSubtypeInterpreter(Map<BlockItem, PropertyBasedSubtypeInterpreter> subtypeInterpreters, ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem blockItem = (BlockItem)item;
        return Optional.ofNullable(subtypeInterpreters.get(blockItem));
    }

    public static void setAdditionalCatalystRegistrar(Consumer<IRecipeCatalystRegistration> additionalCatalystRegistrar) {
        StoragePlugin.additionalCatalystRegistrar = additionalCatalystRegistrar;
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)"default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.getSubtypeIntepreters().forEach((arg_0, arg_1) -> ((ISubtypeRegistration)registration).registerSubtypeInterpreter(arg_0, arg_1));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(StorageScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageScreen>(this){

            public List<Rect2i> getGuiExtraAreas(StorageScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                return ret;
            }
        });
        registration.addGuiContainerHandler(StorageSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<StorageSettingsScreen>(this){

            public List<Rect2i> getGuiExtraAreas(StorageSettingsScreen gui) {
                return new ArrayList<Rect2i>(gui.getSettingsTabControl().getTabRectangles());
            }
        });
        registration.addGhostIngredientHandler(StorageScreen.class, (IGhostIngredientHandler)new StorageGhostIngredientHandler());
        registration.addGhostIngredientHandler(SettingsScreen.class, (IGhostIngredientHandler)new SettingsGhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Map<BlockItem, PropertyBasedSubtypeInterpreter> subtypeInterpreters = this.getSubtypeIntepreters();
        registration.addRecipes(RecipeTypes.CRAFTING, DyeRecipesMaker.getRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
        registration.addRecipes(RecipeTypes.CRAFTING, TierUpgradeRecipesMaker.getShapedCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
        registration.addRecipes(RecipeTypes.CRAFTING, TierUpgradeRecipesMaker.getShapelessCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
        registration.addRecipes(RecipeTypes.CRAFTING, ShulkerBoxFromChestRecipesMaker.getRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
        registration.addRecipes(RecipeTypes.CRAFTING, ClientRecipeHelper.transformAllRecipesOfType((net.minecraft.world.item.crafting.RecipeType)net.minecraft.world.item.crafting.RecipeType.CRAFTING, ShulkerBoxFromVanillaShapelessRecipe.class, ClientRecipeHelper::copyShapelessRecipe));
        registration.addRecipes(RecipeTypes.CRAFTING, FlatBarrelRecipesMaker.getRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CRAFTING_UPGRADE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.STONECUTTER_UPGRADE.get()), new RecipeType[]{RecipeTypes.STONECUTTING});
        additionalCatalystRegistrar.accept(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingContainerRecipeTransferHandlerBase<StorageContainerMenu, RecipeHolder<CraftingRecipe>>(this, handlerHelper, stackHelper){

            public Class<StorageContainerMenu> getContainerClass() {
                return StorageContainerMenu.class;
            }

            public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }
        }, RecipeTypes.CRAFTING);
    }
}

