/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.TranslucentVertexConsumer;

public class BarrelRenderer<T extends BarrelBlockEntity>
extends StorageRenderer<T> {
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.ZERO);

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Block block;
        BlockState blockState = blockEntity.getBlockState();
        boolean flatTop = Boolean.TRUE.equals(blockState.getValue((Property)BarrelBlock.FLAT_TOP));
        if (((WoodStorageBlockEntity)blockEntity).isPacked() || !((block = blockState.getBlock()) instanceof BarrelBlock)) {
            return;
        }
        BarrelBlock storageBlock = (BarrelBlock)block;
        if (blockEntity.getLevel() != null) {
            packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().relative(storageBlock.getFacing(blockState)));
        }
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop, blockState);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop, BlockState blockState) {
        if (!(((BarrelBlockEntity)blockEntity).hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || ((StorageBlockEntity)blockEntity).shouldShowUpgrades())) {
            return;
        }
        poseStack.pushPose();
        Direction facing = (Direction)blockState.getValue((Property)BarrelBlock.FACING);
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(DisplayItemRenderer.getNorthBasedRotation(facing));
        poseStack.translate(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
        boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
        if (((StorageBlockEntity)blockEntity).shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
            if (flatTop) {
                this.flatDisplayItemRenderer.renderUpgradeItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
            } else {
                this.displayItemRenderer.renderUpgradeItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(blockEntity));
            }
        }
        if (((BarrelBlockEntity)blockEntity).hasDynamicRenderer()) {
            if (flatTop) {
                this.flatDisplayItemRenderer.renderDisplayItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !((BarrelBlockEntity)blockEntity).hasFullyDynamicRenderer());
            } else {
                this.displayItemRenderer.renderDisplayItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !((BarrelBlockEntity)blockEntity).hasFullyDynamicRenderer());
            }
        }
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 32;
    }

    protected void renderHiddenTier(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((StorageBlockEntity)blockEntity).shouldShowTier() && this.holdsItemThatShowsHiddenTiers()) {
            this.renderTranslucentQuads(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, BarrelBakedModelBase::getTierQuads);
        }
    }

    protected void renderHiddenLock(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((StorageBlockEntity)blockEntity).shouldShowLock() && ((StorageBlockEntity)blockEntity).isLocked() && this.holdsToolInToggleLockOrLockDisplay()) {
            this.renderTranslucentQuads(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, BarrelBakedModelBase::getLockQuads);
        }
    }

    private void renderTranslucentQuads(T blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, GetQuadsFunction getQuads) {
        RandomSource random;
        String woodName = ((WoodStorageBlockEntity)blockEntity).getWoodType().orElse(WoodType.ACACIA).name();
        BlockState state = blockEntity.getBlockState();
        BakedModel blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        poseStack.pushPose();
        poseStack.translate(-0.005, -0.005, -0.005);
        poseStack.scale(1.01f, 1.01f, 1.01f);
        RandomSource randomSource = random = blockEntity.getLevel() != null ? blockEntity.getLevel().random : Minecraft.getInstance().level.random;
        if (blockModel instanceof BarrelBakedModelBase) {
            BarrelBakedModelBase barrelBakedModel = (BarrelBakedModelBase)blockModel;
            VertexConsumer vertexConsumer = TranslucentVertexConsumer.getVertexConsumer(bufferSource, 128);
            getQuads.apply(barrelBakedModel, state, random, woodName, RenderType.cutout()).forEach(quad -> vertexConsumer.putBulkData(poseStack.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, false));
        }
        poseStack.popPose();
    }

    private static interface GetQuadsFunction {
        public List<BakedQuad> apply(BarrelBakedModelBase var1, BlockState var2, RandomSource var3, String var4, RenderType var5);
    }
}

