/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ColorButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ColorPicker;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.DecorationTableMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import org.jetbrains.annotations.Nullable;

public class DecorationTableScreen
extends AbstractContainerScreen<DecorationTableMenu> {
    public static final ResourceLocation GUI_BACKGROUND = SophisticatedStorage.getRL("textures/gui/decoration_table.png");
    public static final ResourceLocation GUI_DECORATION_TABLE_ELEMENTS = SophisticatedStorage.getRL("textures/gui/decoration_table_elements.png");
    public static final Dimension SQUARE_64 = new Dimension(64, 64);
    public static final Dimension SQUARE_8 = new Dimension(8, 8);
    public static final TextureBlitData TOP_INNER_TRIM_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(0, 0), Dimension.SQUARE_16);
    public static final TextureBlitData TOP_TRIM_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(0, 16), Dimension.SQUARE_16);
    public static final TextureBlitData SIDE_TRIM_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(0, 32), Dimension.SQUARE_16);
    public static final TextureBlitData BOTTOM_TRIM_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(0, 48), Dimension.SQUARE_16);
    public static final TextureBlitData TOP_CORE_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(16, 16), Dimension.SQUARE_16);
    public static final TextureBlitData SIDE_CORE_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(16, 32), Dimension.SQUARE_16);
    public static final TextureBlitData BOTTOM_CORE_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(16, 48), Dimension.SQUARE_16);
    public static final TextureBlitData ACCENT_TINT_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(32, 48), Dimension.SQUARE_16);
    public static final TextureBlitData MAIN_TINT_HIGHLIGHT = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(48, 48), Dimension.SQUARE_16);
    public static final TextureBlitData STORAGE_INFO = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(32, 16), Dimension.SQUARE_16);
    private static final TextureBlitData VERTICAL_ARROW_BACKGROUND = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(56, 0), SQUARE_8);
    private static final TextureBlitData VERTICAL_ARROW_HOVERED_BACKGROUND = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(48, 0), SQUARE_8);
    private static final TextureBlitData HORIZONTAL_ARROW_BACKGROUND = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(56, 8), SQUARE_8);
    private static final TextureBlitData HORIZONTAL_ARROW_HOVERED_BACKGROUND = new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(48, 8), SQUARE_8);
    private static final ButtonDefinition.Toggle<Boolean> VERTICAL_INHERITANCE_ARROW = new ButtonDefinition.Toggle(SQUARE_8, VERTICAL_ARROW_BACKGROUND, Map.of(true, new ToggleButton.StateData(new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(32, 0), SQUARE_8), new Component[]{Component.translatable((String)StorageTranslationHelper.INSTANCE.translButton("decoration_inheritance_on"))}), false, new ToggleButton.StateData(new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(40, 0), SQUARE_8), new Component[]{Component.translatable((String)StorageTranslationHelper.INSTANCE.translButton("decoration_inheritance_off"))})), VERTICAL_ARROW_HOVERED_BACKGROUND);
    private static final ButtonDefinition.Toggle<Boolean> HORIZONTAL_INHERITANCE_ARROW = new ButtonDefinition.Toggle(SQUARE_8, HORIZONTAL_ARROW_BACKGROUND, Map.of(true, new ToggleButton.StateData(new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(32, 8), SQUARE_8), new Component[]{Component.translatable((String)StorageTranslationHelper.INSTANCE.translButton("decoration_inheritance_on"))}), false, new ToggleButton.StateData(new TextureBlitData(GUI_DECORATION_TABLE_ELEMENTS, SQUARE_64, new UV(40, 8), SQUARE_8), new Component[]{Component.translatable((String)StorageTranslationHelper.INSTANCE.translButton("decoration_inheritance_off"))})), HORIZONTAL_ARROW_HOVERED_BACKGROUND);
    private BlockPreview blockPreview;
    private long lastRotationSetTime = 0L;
    @javax.annotation.Nullable
    private ColorPicker colorPicker;
    private final List<Component> resultPartsNeededTooltip = new ArrayList<Component>();
    private static final Map<Integer, Vec2> SLOT_PREVIEW_ROTATIONS = Map.of(0, new Vec2(90.0f, 180.0f), 1, new Vec2(90.0f, 180.0f), 4, new Vec2(90.0f, 180.0f), 2, new Vec2(0.0f, 180.0f), 5, new Vec2(0.0f, 180.0f), 3, new Vec2(-90.0f, 180.0f), 6, new Vec2(-90.0f, 180.0f));

    public DecorationTableScreen(DecorationTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 250;
        this.imageHeight = 226;
        this.inventoryLabelX = 45;
        ((DecorationTableMenu)this.getMenu()).setSlotChangedListener(this::updatePreviewStacks);
    }

    private void updatePreviewStacks() {
        if (this.blockPreview != null) {
            this.blockPreview.setPreviewStacks(((DecorationTableMenu)this.getMenu()).getDecoratedPreviewStacks());
        }
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = ((DecorationTableMenu)this.getMenu()).getSlot((int)3).y + 18 + 2;
        int lastDyeSlotIndex = ((DecorationTableMenu)this.getMenu()).getDyeSlotRange().firstSlot() + ((DecorationTableMenu)this.getMenu()).getDyeSlotRange().numberOfSlots() - 1;
        Slot lastDyeSlot = ((DecorationTableMenu)this.getMenu()).getSlot(lastDyeSlotIndex);
        Slot resultSlot = ((DecorationTableMenu)this.menu).getResultSlot();
        this.blockPreview = new BlockPreview(new Position(this.leftPos + lastDyeSlot.x + 16 + 1 + 8 + 1, this.topPos + lastDyeSlot.y), new Dimension(80, resultSlot.y - lastDyeSlot.y + 16 + 4));
        this.updatePreviewStacks();
        this.addRenderableWidget((GuiEventListener)this.blockPreview);
        this.addVerticalInheritanceArrow(1);
        this.addVerticalInheritanceArrow(2);
        this.addVerticalInheritanceArrow(3);
        int slotIndex = 4;
        this.addInheritanceArrow(slotIndex, -11, 4, HORIZONTAL_INHERITANCE_ARROW);
        this.addVerticalInheritanceArrow(5);
        this.addVerticalInheritanceArrow(6);
        this.addPartHint(0, TOP_INNER_TRIM_HIGHLIGHT, "top_inner_trim");
        this.addPartHint(1, TOP_TRIM_HIGHLIGHT, "top_trim");
        this.addPartHint(2, SIDE_TRIM_HIGHLIGHT, "side_trim");
        this.addPartHint(3, BOTTOM_TRIM_HIGHLIGHT, "bottom_trim");
        this.addPartHint(4, TOP_CORE_HIGHLIGHT, "top");
        this.addPartHint(5, SIDE_CORE_HIGHLIGHT, "side");
        this.addPartHint(6, BOTTOM_CORE_HIGHLIGHT, "bottom");
        Slot slot = ((DecorationTableMenu)this.menu).getSlot(0);
        this.addRenderableWidget((GuiEventListener)new PartStorageInfo(new Position(this.leftPos + slot.x + 57, this.topPos + slot.y), ((DecorationTableMenu)this.menu)::getPartsStored));
        this.addDyeElements();
        if (this.colorPicker != null) {
            this.colorPicker.setPosition(new Position(this.leftPos + (this.imageWidth - ColorPicker.DIMENSIONS.width()) / 2, this.topPos + (this.imageHeight - ColorPicker.DIMENSIONS.height()) / 2));
        }
    }

    private void addDyeElements() {
        Slot greenDyeSlot = ((DecorationTableMenu)this.menu).getSlot(((DecorationTableMenu)this.menu).getDyeSlotRange().firstSlot() + 1);
        Slot topTrimSlot = ((DecorationTableMenu)this.menu).getSlot(1);
        Slot sideTrimSlot = ((DecorationTableMenu)this.menu).getSlot(2);
        ColorButton mainColorButton = new ColorButton(new Position(this.leftPos + greenDyeSlot.x - 1, this.topPos + topTrimSlot.y - 1), new Dimension(18, 18), ((DecorationTableMenu)this.menu)::getMainColor, button -> this.openColorPicker(((DecorationTableMenu)this.menu).getMainColor(), ((DecorationTableMenu)this.menu)::setMainColor), (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translButton("pick_color")));
        this.addRenderableWidget((GuiEventListener)mainColorButton);
        ColorButton accentColorButton = new ColorButton(new Position(this.leftPos + greenDyeSlot.x - 1, this.topPos + sideTrimSlot.y - 1), new Dimension(18, 18), ((DecorationTableMenu)this.menu)::getAccentColor, button -> this.openColorPicker(((DecorationTableMenu)this.menu).getAccentColor(), ((DecorationTableMenu)this.menu)::setAccentColor), (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translButton("pick_color")));
        this.addRenderableWidget((GuiEventListener)accentColorButton);
        this.addRenderableWidget((GuiEventListener)new PartIcon(new Position(mainColorButton.getX() + mainColorButton.getWidth() + 1, mainColorButton.getY() + 1), MAIN_TINT_HIGHLIGHT, (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("tint.main"))));
        this.addRenderableWidget((GuiEventListener)new PartIcon(new Position(accentColorButton.getX() + accentColorButton.getWidth() + 1, accentColorButton.getY() + 1), ACCENT_TINT_HIGHLIGHT, (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("tint.accent"))));
    }

    private void openColorPicker(int color, IntConsumer colorSetter) {
        this.colorPicker = new ColorPicker((Screen)this, new Position(this.leftPos + (this.imageWidth - ColorPicker.DIMENSIONS.width()) / 2, this.topPos + (this.imageHeight - ColorPicker.DIMENSIONS.height()) / 2), color, c -> {
            colorSetter.accept(c);
            this.colorPicker = null;
            this.blockPreview.setVisible(true);
            this.updatePreviewStacks();
        });
        this.blockPreview.setVisible(false);
    }

    private void addVerticalInheritanceArrow(int slotIndex) {
        this.addInheritanceArrow(slotIndex, 4, -11, VERTICAL_INHERITANCE_ARROW);
    }

    private void addInheritanceArrow(final int slotIndex, int xOffset, int yOffset, ButtonDefinition.Toggle<Boolean> arrowDefinition) {
        Slot slot = ((DecorationTableMenu)this.menu).getSlot(slotIndex);
        this.addRenderableWidget((GuiEventListener)new ToggleButton<Boolean>(new Position(this.leftPos + slot.x + xOffset, this.topPos + slot.y + yOffset), arrowDefinition, button -> {
            this.resultPartsNeededTooltip.clear();
            ((DecorationTableMenu)this.getMenu()).setSlotMaterialInheritance(slotIndex, !((DecorationTableMenu)this.getMenu()).isSlotMaterialInherited(slotIndex));
            this.updatePreviewStacks();
        }, () -> ((DecorationTableMenu)this.getMenu()).isSlotMaterialInherited(slotIndex)){

            public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                Vec2 rotations;
                super.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.isMouseOver(mouseX, mouseY) && (rotations = SLOT_PREVIEW_ROTATIONS.get(slotIndex)) != null) {
                    DecorationTableScreen.this.setPreviewRotations((int)rotations.x, (int)rotations.y);
                }
            }
        });
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        guiGraphics.blit(GUI_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderDyeSlotsOverlays(guiGraphics);
        if (this.colorPicker != null) {
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 500.0f);
            this.colorPicker.renderBg(guiGraphics, this.minecraft, i, i1);
            pose.popPose();
        }
    }

    private void renderDyeSlotsOverlays(GuiGraphics guiGraphics) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)this.leftPos, (float)this.topPos, 0.0f);
        Slot redSlot = ((DecorationTableMenu)this.getMenu()).getSlot(((DecorationTableMenu)this.getMenu()).getDyeSlotRange().firstSlot());
        this.renderSlotOverlay(guiGraphics, redSlot, 0x33FF0000);
        Slot greenSlot = ((DecorationTableMenu)this.getMenu()).getSlot(((DecorationTableMenu)this.getMenu()).getDyeSlotRange().firstSlot() + 1);
        this.renderSlotOverlay(guiGraphics, greenSlot, 0x3300FF00);
        Slot blueSlot = ((DecorationTableMenu)this.getMenu()).getSlot(((DecorationTableMenu)this.getMenu()).getDyeSlotRange().firstSlot() + 2);
        this.renderSlotOverlay(guiGraphics, blueSlot, 0x330000FF);
        pose.popPose();
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor) {
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 16, 0, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private void addPartHint(int slotIndex, TextureBlitData texture, String barrelPart) {
        Slot slot = ((DecorationTableMenu)this.menu).getSlot(slotIndex);
        this.addRenderableWidget((GuiEventListener)new PartIcon(new Position(this.leftPos + slot.x + 18, this.topPos + slot.y), texture, (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("barrel_part." + barrelPart))));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updatePreviewRotation(mouseX, mouseY);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.colorPicker != null) {
            this.renderTransparentBackground(guiGraphics);
            RenderSystem.disableBlend();
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 500.0f);
            this.colorPicker.render(guiGraphics, mouseX, mouseY, partialTick);
            this.colorPicker.renderTooltip((Screen)this, guiGraphics, mouseX, mouseY);
            pose.popPose();
        } else {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderSlotContents(GuiGraphics guiGraphics, ItemStack itemstack, Slot slot, @Nullable String countString) {
        if (this.colorPicker != null) {
            return;
        }
        super.renderSlotContents(guiGraphics, itemstack, slot, countString);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        ItemStack inheritedItem;
        if (slot.getItem().isEmpty() && ((DecorationTableMenu)this.getMenu()).isSlotMaterialInherited(slot.index) && !(inheritedItem = ((DecorationTableMenu)this.getMenu()).getInheritedItem(slot.index)).isEmpty()) {
            guiGraphics.renderItem(inheritedItem, slot.x, slot.y, slot.x + slot.y * this.imageWidth);
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            guiGraphics.blit(GuiHelper.GUI_CONTROLS, slot.x, slot.y, 77, 0, 16, 16);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            pose.popPose();
        }
        super.renderSlot(guiGraphics, slot);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List tooltip = super.getTooltipFromContainerItem(stack);
        if (this.hoveredSlot == ((DecorationTableMenu)this.getMenu()).getResultSlot() && !this.hoveredSlot.getItem().isEmpty() && this.hoveredSlot.getItem().getItem() != ModItems.PAINTBRUSH.get()) {
            tooltip.addAll(this.getResultPartsNeededTooltip());
        } else if (!this.resultPartsNeededTooltip.isEmpty()) {
            this.resultPartsNeededTooltip.clear();
        }
        return tooltip;
    }

    private List<Component> getResultPartsNeededTooltip() {
        if (!this.resultPartsNeededTooltip.isEmpty()) {
            return this.resultPartsNeededTooltip;
        }
        Map<ResourceLocation, Integer> partsNeeded = ((DecorationTableMenu)this.getMenu()).getPartsNeeded();
        DecorationTableScreen.addPartCountInfo(partsNeeded, this.resultPartsNeededTooltip, location -> ((DecorationTableMenu)this.getMenu()).getMissingDyes().contains(location) ? ChatFormatting.RED : ChatFormatting.DARK_GRAY);
        return this.resultPartsNeededTooltip;
    }

    private static void addPartCountInfo(Map<ResourceLocation, Integer> partCounts, List<Component> tooltip, Function<ResourceLocation, ChatFormatting> getPartFormatting) {
        LinkedHashMap itemCounts = new LinkedHashMap();
        partCounts.forEach((part, count) -> {
            if (BuiltInRegistries.ITEM.containsKey(part)) {
                Item item = (Item)BuiltInRegistries.ITEM.get(part);
                itemCounts.put(new ItemStack((ItemLike)item), new Tuple(part, count));
            } else {
                BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)part)).flatMap(set -> set.stream().findFirst()).ifPresent(dye -> itemCounts.put(new ItemStack(dye), new Tuple(part, count)));
            }
        });
        itemCounts.entrySet().stream().sorted(Comparator.comparing(entry -> ((ItemStack)entry.getKey()).getHoverName().getString())).forEach(entry -> {
            ItemStack itemStack = (ItemStack)entry.getKey();
            ResourceLocation location = (ResourceLocation)((Tuple)entry.getValue()).getA();
            int count = (Integer)((Tuple)entry.getValue()).getB();
            MutableComponent partCountText = Component.literal((String)(count + "/24 (" + String.format("%.0f%%", Float.valueOf((float)count / 24.0f * 100.0f)) + ") of "));
            tooltip.add((Component)partCountText.append(itemStack.getHoverName()).withStyle((ChatFormatting)getPartFormatting.apply(location)));
        });
    }

    private void updatePreviewRotation(int mouseX, int mouseY) {
        SLOT_PREVIEW_ROTATIONS.forEach((slotIndex, rotation) -> this.updatePreviewRotationForSlot((int)slotIndex, mouseX, mouseY, (int)rotation.x, (int)rotation.y));
        if (this.lastRotationSetTime != 0L && System.currentTimeMillis() - this.lastRotationSetTime > 1000L) {
            this.blockPreview.resetToDefaultRotation();
            this.lastRotationSetTime = 0L;
        }
    }

    private void updatePreviewRotationForSlot(int slotIndex, int mouseX, int mouseY, int xAxisRotation, int yAxisRotation) {
        Slot slot = ((DecorationTableMenu)this.getMenu()).getSlot(slotIndex);
        int slotLeft = this.leftPos + slot.x;
        int slotTop = this.topPos + slot.y;
        if (this.leftPos + slot.x <= mouseX && mouseX < slotLeft + 16 + 18 && slotTop <= mouseY && mouseY < slotTop + 16) {
            this.setPreviewRotations(xAxisRotation, yAxisRotation);
        }
    }

    private void setPreviewRotations(int xAxisRotation, int yAxisRotation) {
        this.blockPreview.setTargetRotations(xAxisRotation, yAxisRotation);
        this.lastRotationSetTime = System.currentTimeMillis();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.colorPicker != null) {
            return this.colorPicker.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseDragged(mouseX, mouseY, button, dragX, dragY)) continue;
            if (child instanceof BlockPreview) {
                this.lastRotationSetTime = System.currentTimeMillis() + 100000L;
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.renderables.forEach(renderable -> {
            if (renderable instanceof WidgetBase) {
                WidgetBase widget = (WidgetBase)renderable;
                widget.renderTooltip((Screen)this, guiGraphics, x, y);
            }
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.colorPicker != null) {
            return this.colorPicker.mouseClicked(mouseX, mouseY, button);
        }
        GuiEventListener focused = this.getFocused();
        if (focused != null && !focused.isMouseOver(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.colorPicker != null) {
            this.colorPicker = null;
            this.blockPreview.setVisible(true);
            this.updatePreviewStacks();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static class BlockPreview
    extends CompositeWidgetBase<WidgetBase> {
        private final List<ItemStack> previewStacks = new ArrayList<ItemStack>();
        private float xAxisRotation = 30.0f;
        private float yAxisRotation = 45.0f;
        private float fromXAxisRotation = this.xAxisRotation;
        private float fromYAxisRotation = this.yAxisRotation;
        private float targetXAxisRotation = this.xAxisRotation;
        private float targetYAxisRotation = this.yAxisRotation;
        private long lastTargetSetTime = 0L;
        private int selectedPreview = 0;
        private final List<StackButton> previewStackButtons = new ArrayList<StackButton>();

        protected BlockPreview(Position position, Dimension dimension) {
            super(position, dimension);
        }

        public void setPreviewStacks(List<ItemStack> previewStacks) {
            this.previewStacks.clear();
            this.previewStacks.addAll(previewStacks);
            this.selectedPreview = 0;
            this.updatePreviewStackButtons();
            this.resetToDefaultRotation();
        }

        private void updatePreviewStackButtons() {
            this.previewStackButtons.forEach(this.children::remove);
            this.previewStackButtons.clear();
            if (this.previewStacks.size() < 2) {
                return;
            }
            int x = this.x + (this.getWidth() - this.previewStacks.size() * 20) / 2;
            for (int i = 0; i < this.previewStacks.size(); ++i) {
                ItemStack stack = this.previewStacks.get(i);
                int finalI = i;
                this.previewStackButtons.add(new StackButton(new Position(x + i * 20, this.y + this.getHeight() - 19), button -> {
                    this.selectedPreview = finalI;
                    this.resetToDefaultRotation();
                }, () -> stack));
            }
            this.previewStackButtons.forEach(x$0 -> {
                StackButton cfr_ignored_0 = (StackButton)this.addChild((WidgetBase)x$0);
            });
        }

        public void resetToDefaultRotation() {
            if (this.previewStacks.isEmpty()) {
                return;
            }
            ItemStack previewStack = this.previewStacks.get(this.selectedPreview);
            if (previewStack.isEmpty()) {
                return;
            }
            ItemTransform guiTransform = this.minecraft.getItemRenderer().getModel(previewStack, null, null, 0).getTransforms().getTransform(ItemDisplayContext.GUI);
            this.setTargetRotations((int)guiTransform.rotation.x(), (int)guiTransform.rotation.y());
        }

        public void setTargetRotations(int xAxisRotation, int yAxisRotation) {
            if (this.targetXAxisRotation == (float)xAxisRotation && this.targetYAxisRotation == (float)yAxisRotation) {
                return;
            }
            this.fromXAxisRotation = this.xAxisRotation;
            this.fromYAxisRotation = this.yAxisRotation;
            this.targetXAxisRotation = xAxisRotation;
            this.targetYAxisRotation = yAxisRotation;
            this.lastTargetSetTime = System.currentTimeMillis();
        }

        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
            guiGraphics.fill(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), -16777216);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.previewStacks.isEmpty()) {
                return;
            }
            ItemStack previewStack = this.previewStacks.get(this.selectedPreview);
            if (previewStack.isEmpty()) {
                return;
            }
            this.updateRotations();
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            float yCenter = (float)(this.getHeight() - (this.previewStackButtons.isEmpty() ? 0 : 20)) / 2.0f;
            pose.translate((float)this.x + (float)this.getWidth() / 2.0f, (float)this.y + yCenter, 150.0f);
            pose.mulPose(Axis.XN.rotationDegrees(this.xAxisRotation));
            pose.mulPose(Axis.YP.rotationDegrees(this.yAxisRotation));
            int scale = 48;
            pose.scale((float)scale, (float)(-scale), (float)scale);
            pose.translate(-0.5, -0.5, -0.5);
            ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(previewStack, null, null, 0);
            int combinedLight = 0xF000F0;
            if (bakedModel.isCustomRenderer()) {
                IClientItemExtensions.of((ItemStack)previewStack).getCustomRenderer().renderByItem(previewStack, ItemDisplayContext.GUI, pose, (MultiBufferSource)guiGraphics.bufferSource(), combinedLight, OverlayTexture.NO_OVERLAY);
            } else {
                Iterator<BakedModel> renderPasses = bakedModel.getRenderPasses(previewStack, true).iterator();
                renderPasses.forEachRemaining(model -> {
                    Iterator<RenderType> renderTypes = model.getRenderTypes(previewStack, true).iterator();
                    renderTypes.forEachRemaining(renderType -> {
                        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)guiGraphics.bufferSource(), (RenderType)renderType, (boolean)true, (boolean)previewStack.hasFoil());
                        itemRenderer.renderModelLists(model, previewStack, combinedLight, OverlayTexture.NO_OVERLAY, pose, vertexconsumer);
                    });
                });
            }
            pose.popPose();
        }

        private void updateRotations() {
            float secondsDuration = 1.0f;
            long currentTime = System.currentTimeMillis();
            if ((float)(currentTime - this.lastTargetSetTime) <= secondsDuration * 1000.0f) {
                float ratio = (float)(currentTime - this.lastTargetSetTime) / (secondsDuration * 1000.0f);
                ratio = Easing.EASE_IN_OUT_CUBIC.ease(ratio);
                this.xAxisRotation = this.fromXAxisRotation + (this.targetXAxisRotation - this.fromXAxisRotation) * ratio;
                this.yAxisRotation = this.fromYAxisRotation + (this.targetYAxisRotation - this.fromYAxisRotation) * ratio;
            } else {
                this.xAxisRotation = this.targetXAxisRotation;
                this.yAxisRotation = this.targetYAxisRotation;
            }
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.previewStackButtons.isEmpty() && mouseY > (double)(this.y + this.getHeight() - 20)) {
                return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            }
            this.yAxisRotation = (float)((double)this.yAxisRotation + 2.0 * dragX);
            this.yAxisRotation %= 360.0f;
            this.xAxisRotation = (float)((double)this.xAxisRotation + 2.0 * dragY);
            this.xAxisRotation %= 360.0f;
            this.targetXAxisRotation = this.xAxisRotation;
            this.targetYAxisRotation = this.yAxisRotation;
            return true;
        }
    }

    private static class PartStorageInfo
    extends WidgetBase {
        private final List<Component> partStorageTooltip = new ArrayList<Component>();
        private final Supplier<Map<ResourceLocation, Integer>> getPartsStored;

        protected PartStorageInfo(Position position, Supplier<Map<ResourceLocation, Integer>> getPartsStored) {
            super(position, Dimension.SQUARE_16);
            this.getPartsStored = getPartsStored;
        }

        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
            if (this.hasNoPartsToShow()) {
                return;
            }
            GuiHelper.blit((GuiGraphics)guiGraphics, (int)this.x, (int)this.y, (TextureBlitData)STORAGE_INFO);
        }

        private boolean hasNoPartsToShow() {
            return this.getPartsStored.get().isEmpty();
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        }

        public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.hasNoPartsToShow()) {
                return;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(screen.getMinecraft().font, this.getPartStorageTooltip(), Optional.empty(), mouseX, mouseY);
            } else if (!this.partStorageTooltip.isEmpty()) {
                this.partStorageTooltip.clear();
            }
        }

        private List<Component> getPartStorageTooltip() {
            if (!this.partStorageTooltip.isEmpty() || this.hasNoPartsToShow()) {
                return this.partStorageTooltip;
            }
            this.partStorageTooltip.add((Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGuiTooltip("parts_stored")));
            DecorationTableScreen.addPartCountInfo(this.getPartsStored.get(), this.partStorageTooltip, location -> ChatFormatting.GRAY);
            return this.partStorageTooltip;
        }
    }

    private static class PartIcon
    extends WidgetBase {
        private final TextureBlitData texture;
        private final Component tooltip;

        protected PartIcon(Position position, TextureBlitData texture, Component tooltip) {
            super(position, new Dimension(texture.getWidth(), texture.getHeight()));
            this.texture = texture;
            this.tooltip = tooltip;
        }

        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
            GuiHelper.blit((GuiGraphics)guiGraphics, (int)this.x, (int)this.y, (TextureBlitData)this.texture);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        }

        public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(screen.getMinecraft().font, this.tooltip, mouseX, mouseY);
            }
        }
    }

    private static class StackButton
    extends ButtonBase {
        private static final TextureBlitData BUTTON_HOVER = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(63, 42), Dimension.SQUARE_18);
        private final Supplier<ItemStack> stackSupplier;

        protected StackButton(Position position, IntConsumer onClick, Supplier<ItemStack> stackSupplier) {
            super(position, Dimension.SQUARE_18, onClick);
            this.stackSupplier = stackSupplier;
        }

        protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            ItemStack stack = this.stackSupplier.get();
            if (stack.isEmpty()) {
                return;
            }
            guiGraphics.renderItem(stack, this.x + 1, this.y + 1);
            if (this.isMouseOver(mouseX, mouseY)) {
                GuiHelper.blit((GuiGraphics)guiGraphics, (int)this.x, (int)this.y, (TextureBlitData)BUTTON_HOVER);
            }
        }
    }
}

