/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.extensions.IDataComponentHolderExtension;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.LimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LimitedBarrelBlock
extends BarrelBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<VerticalFacing> VERTICAL_FACING = EnumProperty.create((String)"vertical_facing", VerticalFacing.class);
    private final Supplier<Integer> getBaseStackSizeMultiplier;

    public LimitedBarrelBlock(int numberOfInventorySlots, Supplier<Integer> getBaseStackSizeMultiplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance) {
        super(() -> numberOfInventorySlots, numberOfUpgradeSlotsSupplier, explosionResistance, stateDef -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateDef.any()).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(VERTICAL_FACING, (Comparable)((Object)VerticalFacing.NO))).setValue((Property)TICKING, (Comparable)Boolean.valueOf(false))).setValue((Property)FLAT_TOP, (Comparable)Boolean.valueOf(false)));
        this.getBaseStackSizeMultiplier = getBaseStackSizeMultiplier;
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        if (this.getVerticalFacing(state) != VerticalFacing.NO) {
            return state;
        }
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    @Override
    public VerticalFacing getVerticalFacing(BlockState state) {
        return (VerticalFacing)((Object)state.getValue(VERTICAL_FACING));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING, VERTICAL_FACING, TICKING, FLAT_TOP});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.getNearestLookingDirection().getOpposite();
        Direction horizontalDirection = blockPlaceContext.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)horizontalDirection)).setValue(VERTICAL_FACING, (Comparable)((Object)VerticalFacing.fromDirection(direction)))).setValue((Property)FLAT_TOP, (Comparable)Boolean.valueOf(BarrelBlockItem.isFlatTop((IDataComponentHolderExtension)blockPlaceContext.getItemInHand())));
    }

    @Override
    public Direction getFacing(BlockState state) {
        VerticalFacing verticalFacing = this.getVerticalFacing(state);
        return verticalFacing == VerticalFacing.NO ? (Direction)state.getValue((Property)HORIZONTAL_FACING) : verticalFacing.getDirection();
    }

    @Override
    public Direction getHorizontalDirection(BlockState state) {
        return (Direction)state.getValue((Property)HORIZONTAL_FACING);
    }

    @Override
    public int getBaseStackSizeMultiplier() {
        return this.getBaseStackSizeMultiplier.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flat) {
        int numberOfInventorySlots = this.getNumberOfInventorySlots();
        String translationKey = numberOfInventorySlots == 1 ? "limited_barrel_singular" : "limited_barrel_plural";
        tooltip.add((Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translBlockTooltipKey(translationKey), (Object[])new Object[]{String.valueOf(numberOfInventorySlots), String.valueOf(this.getBaseStackSizeMultiplier())}).withStyle(ChatFormatting.DARK_GRAY));
    }

    @Override
    @Nullable
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LimitedBarrelBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    protected boolean tryItemInteraction(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand, Direction facing, BlockHitResult hitResult) {
        if (super.tryItemInteraction(player, hand, b, stackInHand, facing, hitResult)) {
            return true;
        }
        if (hitResult.getDirection() != facing || player.isShiftKeyDown()) {
            return false;
        }
        int slot = this.getInteractionSlot(b.getBlockPos(), b.getBlockState(), hitResult);
        if (b instanceof LimitedBarrelBlockEntity) {
            DyeItem dyeItem;
            LimitedBarrelBlockEntity limitedBarrelBlockEntity = (LimitedBarrelBlockEntity)b;
            if (b.isPacked()) {
                return false;
            }
            if (limitedBarrelBlockEntity.depositItem(player, hand, stackInHand, slot)) {
                return true;
            }
            Item item = stackInHand.getItem();
            if (item instanceof DyeItem && limitedBarrelBlockEntity.applyDye(slot, stackInHand, (dyeItem = (DyeItem)item).getDyeColor(), player.isShiftKeyDown())) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean trySneakItemInteraction(Player player, InteractionHand hand, BlockState state, Level level, BlockPos pos, BlockHitResult hitVec, ItemStack itemInHand) {
        if (super.trySneakItemInteraction(player, hand, state, level, pos, hitVec, itemInHand)) {
            return true;
        }
        return this.tryToDyeAll(state, level, pos, hitVec, itemInHand);
    }

    public boolean tryToDyeAll(BlockState state, Level level, BlockPos pos, BlockHitResult hitVec, ItemStack itemStack) {
        if (hitVec.getDirection() != this.getFacing(state) || !(itemStack.getItem() instanceof DyeItem)) {
            return false;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, LimitedBarrelBlockEntity.class).map(barrel -> barrel.applyDye(0, itemStack, ((DyeItem)itemStack.getItem()).getDyeColor(), true)).orElse(false);
    }

    private int getInteractionSlot(BlockPos pos, BlockState state, BlockHitResult hitResult) {
        boolean right;
        int invSlots = this.getNumberOfInventorySlots();
        if (invSlots == 1) {
            return 0;
        }
        Vector3f blockCoords = hitResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).toVector3f();
        blockCoords.add(-0.5f, -0.5f, -0.5f);
        VerticalFacing verticalFacing = this.getVerticalFacing(state);
        if (verticalFacing != VerticalFacing.NO) {
            blockCoords.rotate((Quaternionfc)LimitedBarrelBlock.getNorthBasedRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
            blockCoords.rotate((Quaternionfc)LimitedBarrelBlock.getNorthBasedRotation(verticalFacing.getDirection().getOpposite()));
        } else {
            blockCoords.rotate((Quaternionfc)LimitedBarrelBlock.getNorthBasedRotation(((Direction)state.getValue((Property)HORIZONTAL_FACING)).getOpposite()));
        }
        blockCoords.add(0.5f, 0.5f, 0.5f);
        boolean top = blockCoords.y() > 0.5f;
        boolean bl = right = blockCoords.x() > 0.5f;
        if (invSlots == 2) {
            return top ? 0 : 1;
        }
        if (invSlots == 3) {
            if (top) {
                return 0;
            }
            return right ? 2 : 1;
        }
        if (top) {
            return right ? 1 : 0;
        }
        return right ? 3 : 2;
    }

    @Override
    protected StorageContainerMenu instantiateContainerMenu(int w, Player pl, BlockPos pos) {
        return new LimitedBarrelContainerMenu(w, pl, pos);
    }

    public static Quaternionf getNorthBasedRotation(Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                Quaternionf quaternion = Axis.XP.rotationDegrees(90.0f);
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                yield quaternion;
            }
            case Direction.UP -> {
                Quaternionf quaternion = Axis.XP.rotationDegrees(-90.0f);
                quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                yield quaternion;
            }
            case Direction.NORTH -> new Quaternionf();
            case Direction.SOUTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(-90.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(90.0f);
        };
    }

    private Optional<BlockHitResult> getHitResult(Player player) {
        Optional<BlockHitResult> optional;
        HitResult hitResult = player.pick(player.blockInteractionRange(), 0.0f, false);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            optional = Optional.of(blockHitResult);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (level.isClientSide()) {
            return;
        }
        this.tryToTakeItem(state, level, pos, player);
    }

    public boolean tryToTakeItem(BlockState state, Level level, BlockPos pos, Player player) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, LimitedBarrelBlockEntity.class).map(be -> this.tryToTakeItem(state, level, pos, player, (LimitedBarrelBlockEntity)be)).orElse(false);
    }

    private boolean tryToTakeItem(BlockState state, Level level, BlockPos pos, Player player, LimitedBarrelBlockEntity be) {
        return this.getHitResult(player).map(blockHitResult -> {
            if (!blockHitResult.getBlockPos().equals((Object)pos) || level.getBlockState(pos) != state || blockHitResult.getDirection() != this.getFacing(state)) {
                return false;
            }
            return !be.isPacked() && be.tryToTakeItem(player, this.getInteractionSlot(pos, state, (BlockHitResult)blockHitResult));
        }).orElse(false);
    }

    public boolean isLookingAtFront(Player player, BlockPos pos, BlockState state) {
        return this.getHitResult(player).map(blockHitResult -> blockHitResult.getBlockPos().equals((Object)pos) && blockHitResult.getDirection() == this.getFacing(state)).orElse(false);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, LimitedBarrelBlockEntity.class).ifPresent(be -> LimitedBarrelBlock.setupDefaultSettings(be.getStorageWrapper(), be.getStorageWrapper().getNumberOfInventorySlots()));
    }

    public static void setupDefaultSettings(IStorageWrapper storageWrapper, int numberOfInventorySlots) {
        SettingsHandler settingsHandler = storageWrapper.getSettingsHandler();
        ((ItemDisplaySettingsCategory)settingsHandler.getTypeCategory(ItemDisplaySettingsCategory.class)).selectSlots(0, numberOfInventorySlots);
        ((NoSortSettingsCategory)settingsHandler.getTypeCategory(NoSortSettingsCategory.class)).selectSlots(0, numberOfInventorySlots);
        ((MemorySettingsCategory)settingsHandler.getTypeCategory(MemorySettingsCategory.class)).setIgnoreNbt(false);
    }

    @Override
    public int getDisplayItemsCount(List<RenderInfo.DisplayItem> displayItems) {
        return this.getNumberOfInventorySlots();
    }

    @Override
    public boolean hasFixedIndexDisplayItems() {
        return true;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }
}

