/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.handoveryouritems_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.handoveryouritems_common_neoforge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class HandOverEvent {
    public static InteractionResult onPlayerClick(Player player, Level level, InteractionHand hand, Entity target, EntityHitResult hitResult) {
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof Player)) {
            return InteractionResult.PASS;
        }
        ItemStack stacktogive = player.getItemInHand(hand);
        if (stacktogive.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (ConfigHandler.mustCrouchToGiveItem && !player.isCrouching()) {
            return InteractionResult.PASS;
        }
        int stacksize = stacktogive.getCount();
        String itemstring = ItemFunctions.itemToReadableString((Item)stacktogive.getItem());
        Player playertarget = (Player)target;
        ItemFunctions.giveOrDropItemStack((Player)playertarget, (ItemStack)stacktogive.copy());
        stacktogive.setCount(0);
        if (!level.isClientSide) {
            if (ConfigHandler.sendItemReceivedMessage) {
                MessageFunctions.sendMessage((Player)playertarget, (String)("You have been given " + stacksize + " " + itemstring + " by " + player.getName().getString() + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
            if (ConfigHandler.sendItemGivenMessage) {
                MessageFunctions.sendMessage((Player)player, (String)("You have given " + stacksize + " " + itemstring + " to " + target.getName().getString() + "."), (ChatFormatting)ChatFormatting.BLUE);
            }
        }
        player.getInventory().setChanged();
        playertarget.getInventory().setChanged();
        return InteractionResult.FAIL;
    }
}

