/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.disenchanting_table.core.world.block.entity;

import java.util.Map;
import neoforge.com.cursee.disenchanting_table.core.CommonConfigValues;
import neoforge.com.cursee.disenchanting_table.core.network.packet.NeoForgeItemSyncS2CPacket;
import neoforge.com.cursee.disenchanting_table.core.registry.ForgeBlockEntities;
import neoforge.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import neoforge.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import neoforge.com.cursee.disenchanting_table.core.util.LazyOptional;
import neoforge.com.cursee.disenchanting_table.core.world.block.entity.InventoryDirectionEntry;
import neoforge.com.cursee.disenchanting_table.core.world.block.entity.InventoryDirectionWrapper;
import neoforge.com.cursee.disenchanting_table.core.world.block.entity.WrappedHandler;
import neoforge.com.cursee.disenchanting_table.core.world.inventory.AutoDisEnchantingMenu;
import neoforge.com.cursee.disenchanting_table.core.world.inventory.ManualDisenchantingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeDisEnchantingBE
extends BlockEntity
implements MenuProvider,
WorldlyContainer,
IBlockCapabilityProvider {
    private ItemStackHandler itemHandler = new DisenchantingTableItemStackHandler();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap;
    private int progress;
    private final ContainerData containerData;
    @Nullable
    private Holder<Enchantment> keptEnchantment;
    @Nullable
    private Integer keptEnchantmentLevel;
    @Nullable
    private ItemEnchantments stolenEnchantments;

    public ForgeDisEnchantingBE(BlockPos pos, BlockState state) {
        this(ForgeBlockEntities.DISENCHANTING_TABLE, pos, state);
    }

    public ForgeDisEnchantingBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.directionWrappedHandlerMap = new InventoryDirectionWrapper((IItemHandlerModifiable)this.itemHandler, (InventoryDirectionEntry[])new InventoryDirectionEntry[]{new InventoryDirectionEntry((Direction)Direction.DOWN, (int)2, (boolean)false), new InventoryDirectionEntry((Direction)Direction.NORTH, (int)1, (boolean)CommonConfigValues.automatic_disenchanting), new InventoryDirectionEntry((Direction)Direction.SOUTH, (int)1, (boolean)CommonConfigValues.automatic_disenchanting), new InventoryDirectionEntry((Direction)Direction.EAST, (int)1, (boolean)CommonConfigValues.automatic_disenchanting), new InventoryDirectionEntry((Direction)Direction.WEST, (int)1, (boolean)CommonConfigValues.automatic_disenchanting), new InventoryDirectionEntry((Direction)Direction.UP, (int)0, (boolean)CommonConfigValues.automatic_disenchanting)}).directionsMap;
        this.progress = 0;
        this.stolenEnchantments = ItemEnchantments.EMPTY;
        this.containerData = new DisenchantingTableContainerData();
    }

    public void doTick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        boolean validInputs;
        if (level == null) {
            return;
        }
        boolean bl = validInputs = DisenchantmentHelper.canRemoveEnchantments(this.getItem(0)) && this.getItem(1).is(Items.BOOK);
        if (validInputs && this.getItem(2).isEmpty() && this.nearestPlayerHasEnoughExperience(level, pos)) {
            ++this.progress;
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.progress >= 10) {
                this.disenchant(level, pos);
                this.setChanged();
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    protected void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        data.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        data.putInt("progress", this.progress);
        super.saveAdditional(data, registries);
    }

    protected void loadAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.loadAdditional(data, registries);
        if (CommonConfigValues.automatic_disenchanting) {
            this.itemHandler.deserializeNBT(registries, data.getCompound("inventory"));
        }
        this.progress = data.getInt("progress");
    }

    public void setChanged() {
        if (this.level != null && !this.level.isClientSide()) {
            NonNullList inventory = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                inventory.set(i, (Object)this.itemHandler.getStackInSlot(i));
            }
            for (Player player : this.level.players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new NeoForgeItemSyncS2CPacket(this.getBlockPos().asLong(), inventory.size(), (Holder<Item>)new Holder.Direct((Object)((ItemStack)inventory.get(2)).getItem())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        super.setChanged();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.disenchanting_table.disenchanting_table");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerIndex, Inventory playerInventory, Player player) {
        if (!CommonConfigValues.automatic_disenchanting) {
            return new ManualDisenchantingMenu(containerIndex, playerInventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()));
        }
        return new AutoDisEnchantingMenu(containerIndex, playerInventory, (Container)this, this.containerData);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    public int getContainerSize() {
        return 3;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getItem(int pSlot) {
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return this.itemHandler.extractItem(pSlot, pAmount, false);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return this.itemHandler.extractItem(pSlot, this.itemHandler.getStackInSlot(pSlot).getCount(), true);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.itemHandler.setStackInSlot(pSlot, pStack);
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    @Nullable
    public Object getCapability(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Object o) {
        ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(blockPos).getBlock());
        return BlockCapability.createSided((ResourceLocation)rl, ItemStackHandler.class);
    }

    private void disenchant(Level level, BlockPos pos) {
        ItemStack input = this.getItem(0);
        if (!input.is(Items.ENCHANTED_BOOK)) {
            this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
            ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
            this.setItem(2, result);
            if (CommonConfigValues.resets_repair_cost) {
                input.set(DataComponents.REPAIR_COST, (Object)0);
            }
            EnchantmentHelper.setEnchantments((ItemStack)input, (ItemEnchantments)ItemEnchantments.EMPTY);
            this.setItem(0, input);
            ItemStack extra = this.getItem(1);
            extra.shrink(1);
            this.setItem(1, extra);
        } else {
            this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
            this.keptEnchantment = (Holder)this.stolenEnchantments.keySet().stream().findFirst().get();
            this.keptEnchantmentLevel = this.stolenEnchantments.getLevel(this.keptEnchantment);
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(this.stolenEnchantments);
            mutable.removeIf(enchantmentHolder -> enchantmentHolder.value() == this.keptEnchantment.value());
            this.stolenEnchantments = mutable.toImmutable();
            ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
            this.setItem(2, result);
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == null) {
                return;
            }
            ItemStack keptEnchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(this.keptEnchantment, this.keptEnchantmentLevel.intValue()));
            this.setItem(0, keptEnchantedBook);
            ItemStack bookStack = this.getItem(1);
            bookStack.shrink(1);
            this.setItem(1, bookStack);
        }
        if (!CommonConfigValues.requires_experience) {
            return;
        }
        Player player = this.nearestPlayer(level, pos);
        if (!CommonConfigValues.requires_experience || player == null || player.getAbilities().instabuild) {
            return;
        }
        if (CommonConfigValues.uses_points) {
            if (player.totalExperience >= CommonConfigValues.experience_cost) {
                player.giveExperiencePoints(-CommonConfigValues.experience_cost);
            } else {
                --player.experienceLevel;
                int newXP = player.getXpNeededForNextLevel();
                player.giveExperiencePoints(newXP -= CommonConfigValues.experience_cost);
            }
        } else {
            player.giveExperienceLevels(-CommonConfigValues.experience_cost);
        }
    }

    public void setInventory(NonNullList<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)list.get(i));
        }
    }

    public ItemStack getRenderStack() {
        return !this.getItem(2).isEmpty() ? this.getItem(2) : this.getItem(0);
    }

    @Nullable
    private Player nearestPlayer(Level level, BlockPos pos) {
        return level.getNearestPlayer(TargetingConditions.forNonCombat(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    private boolean nearestPlayerHasEnoughExperience(Level level, BlockPos pos) {
        Player player = this.nearestPlayer(level, pos);
        if (player == null) {
            return false;
        }
        if (player.getAbilities().instabuild) {
            return true;
        }
        if (!CommonConfigValues.requires_experience) {
            return true;
        }
        if (CommonConfigValues.uses_points && ExperienceHelper.totalPointsFromLevelAndProgress(player.experienceLevel, player.experienceProgress) >= CommonConfigValues.experience_cost) {
            return true;
        }
        return !CommonConfigValues.uses_points && player.experienceLevel >= CommonConfigValues.experience_cost;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction side) {
        int[] nArray;
        if (side == Direction.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0 && DisenchantmentHelper.canRemoveEnchantments(stack) || slot == 1 && stack.is(Items.BOOK);
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction side) {
        return CommonConfigValues.automatic_disenchanting && side != Direction.DOWN && this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack pStack, Direction side) {
        return CommonConfigValues.automatic_disenchanting && side == Direction.DOWN && slot == 2;
    }

    public class DisenchantingTableItemStackHandler
    extends ItemStackHandler
    implements IItemHandlerModifiable {
        public DisenchantingTableItemStackHandler() {
            super(3);
        }

        protected void onContentsChanged(int slot) {
            ForgeDisEnchantingBE.this.setChanged();
            if (ForgeDisEnchantingBE.this.level != null && !ForgeDisEnchantingBE.this.level.isClientSide()) {
                ForgeDisEnchantingBE.this.level.sendBlockUpdated(ForgeDisEnchantingBE.this.getBlockPos(), ForgeDisEnchantingBE.this.getBlockState(), ForgeDisEnchantingBE.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (CommonConfigValues.automatic_disenchanting && DisenchantmentHelper.canRemoveEnchantments(stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (CommonConfigValues.automatic_disenchanting && stack.is(Items.BOOK)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }

    public class DisenchantingTableContainerData
    implements ContainerData {
        public int get(int index) {
            return index == 0 ? ForgeDisEnchantingBE.this.progress : 0;
        }

        public void set(int index, int value) {
            if (index == 0) {
                ForgeDisEnchantingBE.this.progress = value;
            }
        }

        public int getCount() {
            return 1;
        }
    }
}

