/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.world.inventory;

import forge.com.cursee.disenchanting_table.core.CommonConfigValues;
import forge.com.cursee.disenchanting_table.core.registry.ModBlocks;
import forge.com.cursee.disenchanting_table.core.registry.ModMenus;
import forge.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import forge.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ManualDisenchantingMenu
extends ItemCombinerMenu {
    @Nullable
    private Holder<Enchantment> keptEnchantment;
    private int keptEnchantmentLevel = 0;
    private ItemEnchantments stolenEnchantments = ItemEnchantments.EMPTY;
    public int cost = 0;
    public final DataSlot mayPickup;
    private final Player player;

    public ManualDisenchantingMenu(int containerIndex, Inventory playerInventory) {
        this(containerIndex, playerInventory, ContainerLevelAccess.NULL);
    }

    public ManualDisenchantingMenu(int containerIndex, Inventory playerInventory, ContainerLevelAccess containerLevelAccess) {
        super(ModMenus.MANUAL_DISENCHANTING_TABLE, containerIndex, playerInventory, containerLevelAccess);
        this.player = playerInventory.player;
        this.mayPickup = DataSlot.standalone();
        this.addDataSlot(this.mayPickup);
        this.mayPickup.set(0);
    }

    protected boolean mayPickup(Player player, boolean b) {
        int currentExperience = ExperienceHelper.totalPointsFromLevelAndProgress(player.experienceLevel, player.experienceProgress);
        boolean creative = player.getAbilities().instabuild;
        boolean experiencePoints = CommonConfigValues.uses_points && currentExperience >= this.cost;
        boolean experienceLevels = !CommonConfigValues.uses_points && player.experienceLevel >= this.cost;
        boolean experience = experiencePoints || experienceLevels;
        boolean books = this.inputSlots.getItem(1).is(Items.BOOK);
        this.mayPickup.set((creative || experience) && books ? 1 : 0);
        return this.mayPickup.get() == 1;
    }

    protected boolean isValidBlock(BlockState blockState) {
        return blockState.is(ModBlocks.DISENCHANTING_TABLE);
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, DisenchantmentHelper::canRemoveEnchantments).withSlot(1, 76, 47, stack -> stack.is(Items.BOOK)).withResultSlot(2, 134, 47).build();
    }

    public void createResult() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack extra = this.inputSlots.getItem(1);
        if (!DisenchantmentHelper.canRemoveEnchantments(input) || !extra.is(Items.BOOK)) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.cost = 0;
            return;
        }
        if (!input.is(Items.ENCHANTED_BOOK)) {
            this.keptEnchantment = null;
            this.keptEnchantmentLevel = 0;
            this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
            ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
            this.resultSlots.setItem(0, result);
        } else {
            this.stolenEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
            this.keptEnchantment = (Holder)this.stolenEnchantments.keySet().iterator().next();
            this.keptEnchantmentLevel = this.stolenEnchantments.getLevel(this.keptEnchantment);
            ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(this.stolenEnchantments);
            mutableEnchantments.removeIf(enchantmentHolder -> enchantmentHolder.value() == this.keptEnchantment.value());
            this.stolenEnchantments = mutableEnchantments.toImmutable();
            ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)this.stolenEnchantments);
            this.resultSlots.setItem(0, result);
        }
        if (!this.resultSlots.isEmpty() && CommonConfigValues.requires_experience) {
            int currentExperience = ExperienceHelper.totalPointsFromLevelAndProgress(player2.experienceLevel, player2.experienceProgress);
            boolean creative = this.player.getAbilities().instabuild;
            boolean experiencePoints = CommonConfigValues.uses_points && currentExperience >= this.cost;
            boolean experienceLevels = !CommonConfigValues.uses_points && player2.experienceLevel >= this.cost;
            boolean experience = experiencePoints || experienceLevels;
            boolean books = this.inputSlots.getItem(1).is(Items.BOOK);
            boolean requiresExperience = CommonConfigValues.requires_experience;
            boolean satisfiesCost = (creative || experience) && books;
            this.mayPickup.set(requiresExperience && satisfiesCost ? 1 : 0);
            this.cost = CommonConfigValues.experience_cost;
        }
    }

    protected void onTake(Player player, ItemStack itemStack) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack extra = this.inputSlots.getItem(1);
        if (!input.is(Items.ENCHANTED_BOOK)) {
            if (CommonConfigValues.resets_repair_cost) {
                input.set(DataComponents.REPAIR_COST, (Object)0);
            }
            EnchantmentHelper.setEnchantments((ItemStack)input, (ItemEnchantments)EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)ItemStack.EMPTY));
            this.inputSlots.setItem(0, input);
        } else {
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == 0) {
                return;
            }
            this.inputSlots.setItem(0, EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(this.keptEnchantment, this.keptEnchantmentLevel)));
        }
        extra.shrink(1);
        this.inputSlots.setItem(1, extra);
        this.keptEnchantment = null;
        this.keptEnchantmentLevel = 0;
        this.stolenEnchantments = null;
        if (!CommonConfigValues.requires_experience) {
            return;
        }
        if (CommonConfigValues.uses_points) {
            player.giveExperiencePoints(-CommonConfigValues.experience_cost);
        } else {
            player.giveExperienceLevels(-CommonConfigValues.experience_cost);
        }
        this.cost = 0;
    }

    public boolean hasResult() {
        return !this.resultSlots.isEmpty();
    }
}

