/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table.core.world.block.entity;

import fabric.com.cursee.disenchanting_table.core.CommonConfigValues;
import fabric.com.cursee.disenchanting_table.core.network.packet.FabricItemSyncS2CPacket;
import fabric.com.cursee.disenchanting_table.core.registry.FabricBlockEntities;
import fabric.com.cursee.disenchanting_table.core.util.DisenchantmentHelper;
import fabric.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import fabric.com.cursee.disenchanting_table.core.world.block.entity.IContainer;
import fabric.com.cursee.disenchanting_table.core.world.inventory.AutoDisEnchantingMenu;
import fabric.com.cursee.disenchanting_table.core.world.inventory.ManualDisenchantingMenu;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_4051;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FabricDisEnchantingBE
extends class_2586
implements class_3908,
IContainer {
    private int progress = 0;
    private final class_3913 containerData;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    @Nullable
    private class_6880<class_1887> keptEnchantment;
    private int keptEnchantmentLevel;
    private class_9304 stolenEnchantments = class_9304.field_49385;

    public FabricDisEnchantingBE(class_2338 pos, class_2680 state) {
        this(FabricBlockEntities.DISENCHANTING_TABLE, pos, state);
    }

    public FabricDisEnchantingBE(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.containerData = new DisenchantingTableContainerData();
    }

    public void doTick(class_1937 level, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        boolean validInputs;
        if (level == null) {
            return;
        }
        boolean bl = validInputs = DisenchantmentHelper.canRemoveEnchantments(this.method_5438(0)) && this.method_5438(1).method_31574(class_1802.field_8529);
        if (validInputs && this.method_5438(2).method_7960() && this.nearestPlayerHasEnoughExperience(level, pos)) {
            ++this.progress;
            class_2586.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
            if (this.progress >= 10) {
                this.disenchant(level, pos);
                this.method_5431();
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void setInventory(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.inventory.set(i, (Object)((class_1799)list.get(i)));
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)registries);
        tag.method_10569("progress", this.progress);
        super.method_11007(tag, registries);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        class_1262.method_5429((class_2487)tag, this.inventory, (class_7225.class_7874)registries);
        this.progress = tag.method_10550("progress");
    }

    @Override
    public void method_5431() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            for (class_1657 player : this.field_11863.method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new FabricItemSyncS2CPacket(this.method_11016(), this.inventory.size(), this.inventory));
            }
        }
        super.method_5431();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.disenchanting_table.disenchanting_table");
    }

    @Nullable
    public class_1703 createMenu(int containerIndex, class_1661 playerInventory, class_1657 player) {
        if (!CommonConfigValues.automatic_disenchanting) {
            return new ManualDisenchantingMenu(containerIndex, playerInventory, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.method_11016()));
        }
        return new AutoDisEnchantingMenu(containerIndex, playerInventory, (class_1263)this, this.containerData);
    }

    private void disenchant(class_1937 level, class_2338 pos) {
        class_1799 input = this.method_5438(0);
        if (!input.method_31574(class_1802.field_8598)) {
            this.stolenEnchantments = class_1890.method_57532((class_1799)input);
            class_1799 result = new class_1799((class_1935)class_1802.field_8598);
            class_1890.method_57530((class_1799)result, (class_9304)this.stolenEnchantments);
            this.method_5447(2, result);
            if (CommonConfigValues.resets_repair_cost) {
                input.method_57379(class_9334.field_49639, (Object)0);
            }
            class_1890.method_57530((class_1799)input, (class_9304)class_1890.method_57532((class_1799)class_1799.field_8037));
            this.method_5447(0, input);
            class_1799 extra = this.method_5438(1);
            extra.method_7934(1);
            this.method_5447(1, extra);
        } else {
            this.stolenEnchantments = class_1890.method_57532((class_1799)input);
            this.keptEnchantment = (class_6880)this.stolenEnchantments.method_57534().iterator().next();
            this.keptEnchantmentLevel = this.stolenEnchantments.method_57536(this.keptEnchantment);
            class_9304.class_9305 mutableEnchantments = new class_9304.class_9305(this.stolenEnchantments);
            mutableEnchantments.method_57548(enchantmentHolder -> enchantmentHolder.comp_349() == this.keptEnchantment.comp_349());
            this.stolenEnchantments = mutableEnchantments.method_57549();
            class_1799 result = new class_1799((class_1935)class_1802.field_8598);
            class_1890.method_57530((class_1799)result, (class_9304)this.stolenEnchantments);
            this.method_5447(2, result);
            if (this.keptEnchantment == null || this.keptEnchantmentLevel == 0) {
                return;
            }
            class_1799 keptEnchantedBook = class_1772.method_7808((class_1889)new class_1889(this.keptEnchantment, this.keptEnchantmentLevel));
            this.method_5447(0, keptEnchantedBook);
            class_1799 bookStack = this.method_5438(1);
            bookStack.method_7934(1);
            this.method_5447(1, bookStack);
        }
        if (!CommonConfigValues.requires_experience) {
            return;
        }
        class_1657 player = this.nearestPlayer(level, pos);
        if (!CommonConfigValues.requires_experience || player == null || player.method_31549().field_7477) {
            return;
        }
        if (CommonConfigValues.uses_points) {
            if (player.field_7495 >= CommonConfigValues.experience_cost) {
                player.method_7255(-CommonConfigValues.experience_cost);
            } else {
                --player.field_7520;
                int newXP = player.method_7349();
                player.method_7255(newXP -= CommonConfigValues.experience_cost);
            }
        } else {
            player.method_7316(-CommonConfigValues.experience_cost);
        }
    }

    public class_1799 getRenderStack() {
        return !this.method_5438(2).method_7960() ? this.method_5438(2) : this.method_5438(0);
    }

    @Nullable
    private class_1657 nearestPlayer(class_1937 level, class_2338 pos) {
        return level.method_18461(class_4051.method_36626(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    private boolean nearestPlayerHasEnoughExperience(class_1937 level, class_2338 pos) {
        class_1657 player = this.nearestPlayer(level, pos);
        if (player == null) {
            return false;
        }
        if (player.method_31549().field_7477) {
            return true;
        }
        if (!CommonConfigValues.requires_experience) {
            return true;
        }
        if (CommonConfigValues.uses_points && ExperienceHelper.totalPointsFromLevelAndProgress(player.field_7520, player.field_7510) >= CommonConfigValues.experience_cost) {
            return true;
        }
        return !CommonConfigValues.uses_points && player.field_7520 >= CommonConfigValues.experience_cost;
    }

    public void method_11012() {
        super.method_11012();
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        return CommonConfigValues.automatic_disenchanting && side != class_2350.field_11033 && this.method_5437(slot, stack);
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 side) {
        return CommonConfigValues.automatic_disenchanting && side == class_2350.field_11033 && slot == 2;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index == 0 && DisenchantmentHelper.canRemoveEnchantments(stack) || index == 1 && stack.method_31574(class_1802.field_8529);
    }

    public boolean method_49104(class_1263 target, int index, class_1799 stack) {
        return index == 2;
    }

    public class DisenchantingTableContainerData
    implements class_3913 {
        public int method_17390(int index) {
            return index == 0 ? FabricDisEnchantingBE.this.progress : 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                FabricDisEnchantingBE.this.progress = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    }
}

