/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;

public class DefaultLaunchHandlerService
implements ILaunchHandlerService {
    public static final String LAUNCH_PROPERTY = "minecraft.client.jar";
    public static final String LAUNCH_PATH_STRING = System.getProperty("minecraft.client.jar");

    @Override
    public String name() {
        return "minecraft";
    }

    @Override
    public ServiceRunner launchService(String[] arguments, ModuleLayer gameLayer) {
        return () -> {
            Class<?> mcClass = Class.forName(gameLayer.findModule("minecraft").orElseThrow(), "net.minecraft.client.main.Main");
            Method mcClassMethod = mcClass.getMethod("main", String[].class);
            mcClassMethod.invoke(null, new Object[]{arguments});
        };
    }

    @Override
    public NamedPath[] getPaths() {
        return new NamedPath[]{new NamedPath("launch", FileSystems.getDefault().getPath(LAUNCH_PATH_STRING, new String[0]))};
    }
}

