/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.item.colored;

import com.benbenlaw.core.block.colored.util.BlockTypeColorFinder;
import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.item.TooltipUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ColoringItem
extends Item {
    private final DyeColor color;

    public ColoringItem(Item.Properties properties, DyeColor color) {
        super(properties.component(CoreDataComponents.MASS_SPRAYING, (Object)false));
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (itemStack.isDamageableItem()) {
            ItemStack stackInCraftingTable = itemStack.copy();
            stackInCraftingTable.setDamageValue(stackInCraftingTable.getDamageValue() + 1);
            if (stackInCraftingTable.getDamageValue() >= stackInCraftingTable.getMaxDamage()) {
                return ItemStack.EMPTY;
            }
            return stackInCraftingTable;
        }
        return super.getCraftingRemainingItem(itemStack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (Screen.hasShiftDown()) {
            boolean currentMassSpraying = Boolean.TRUE.equals(stack.get(CoreDataComponents.MASS_SPRAYING));
            stack.set(CoreDataComponents.MASS_SPRAYING, (Object)(!currentMassSpraying ? 1 : 0));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        InteractionHand hand = context.getHand();
        if (!level.isClientSide()) {
            if (state.getBlock() instanceof IColored) {
                Block block;
                Property colorProperty;
                DyeColor dyeColor = null;
                Function<BlockState, DyeColor> colorRetriever = BlockTypeColorFinder.BLOCK_TYPE_COLOR_FINDER.get(state.getBlock().getClass());
                if (colorRetriever != null) {
                    dyeColor = colorRetriever.apply(state);
                }
                if ((colorProperty = (block = state.getBlock()).getStateDefinition().getProperty("color")) != null && dyeColor != null) {
                    state = (BlockState)state.setValue(colorProperty, (Comparable)this.color);
                    if (Boolean.TRUE.equals(stack.get(CoreDataComponents.MASS_SPRAYING))) {
                        this.massConvertBlocks(level, pos, state, player, stack, state);
                    } else {
                        level.setBlock(pos, state, 3);
                    }
                }
                if (stack.isDamageableItem()) {
                    assert (player != null);
                    stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                } else {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            for (String colorCheck : colors) {
                if (!state.getBlock().getName().toString().contains(colorCheck) || state.getBlock() instanceof BaseEntityBlock) continue;
                String block = state.getBlock().toString();
                String blockString = block.replace("Block{", "").replace("}", "");
                String newColoredBlock = blockString.replace(colorCheck, this.color.toString().toLowerCase());
                ResourceLocation newBlockResourceLocation = ResourceLocation.tryParse((String)newColoredBlock);
                if (newBlockResourceLocation != null && BuiltInRegistries.BLOCK.containsKey(newBlockResourceLocation)) {
                    Block newBlock = (Block)BuiltInRegistries.BLOCK.get(newBlockResourceLocation);
                    BlockState newState = newBlock.defaultBlockState();
                    for (Property property : state.getProperties()) {
                        if (!newState.hasProperty(property)) continue;
                        newState = this.copyProperty(state, newState, property);
                    }
                    if (Boolean.TRUE.equals(stack.get(CoreDataComponents.MASS_SPRAYING))) {
                        this.massConvertBlocks(level, pos, state, player, stack, newState);
                    } else {
                        level.setBlock(pos, newState, 3);
                    }
                    if (stack.isDamageableItem()) {
                        assert (player != null);
                        stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                    } else {
                        stack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                System.out.println("Failed to parse resource location: " + newColoredBlock);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    private void massConvertBlocks(Level level, BlockPos startPos, BlockState targetState, Player player, ItemStack itemStack, BlockState newBlockState) {
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.add(startPos);
        int blocksConverted = 0;
        while (!toVisit.isEmpty() && itemStack.getDamageValue() < itemStack.getMaxDamage()) {
            BlockState currentState;
            BlockPos currentPos = (BlockPos)toVisit.poll();
            if (visited.contains(currentPos) || (currentState = level.getBlockState(currentPos)).getBlock() != targetState.getBlock()) continue;
            visited.add(currentPos);
            this.convertBlocks(level, currentPos, currentState, player, itemStack, newBlockState);
            ++blocksConverted;
            for (Direction direction : Direction.values()) {
                BlockPos adjacentPos = currentPos.relative(direction);
                if (visited.contains(adjacentPos)) continue;
                toVisit.add(adjacentPos);
            }
        }
        if (blocksConverted > 0) {
            level.playSound(null, startPos, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void convertBlocks(Level level, BlockPos pos, BlockState blockState, Player player, ItemStack itemStack, BlockState newBlockState) {
        for (Property property : blockState.getProperties()) {
            if (!newBlockState.hasProperty(property)) continue;
            newBlockState = this.copyProperty(blockState, newBlockState, property);
        }
        level.setBlock(pos, newBlockState, 3);
        if (itemStack.isDamageableItem()) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(itemStack));
        } else {
            itemStack.shrink(1);
        }
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.setValue(property, oldState.getValue(property));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag flag) {
        boolean massSpraying = (Boolean)stack.get(CoreDataComponents.MASS_SPRAYING);
        MutableComponent massSprayingComponent = Component.literal((String)"");
        if (massSpraying) {
            massSprayingComponent = Component.translatable((String)"tooltips.coloring_item.mass_spraying");
        }
        String massSprayingComponentTranslated = massSprayingComponent.getString();
        TooltipUtil.addShiftTooltip(list, "tooltips.coloring_item.shift.held");
        MutableComponent colorComponent = Component.translatable((String)ColorMap.getTranslationKey(this.color.toString()));
        StringBuilder nameBuilder = new StringBuilder().append(colorComponent.getString());
        TextColor textColor = this.color == DyeColor.BLACK ? TextColor.fromRgb((int)0x3C3C3C) : TextColor.fromRgb((int)this.color.getTextColor());
        list.add((Component)Component.literal((String)("Color: " + String.valueOf(nameBuilder) + massSprayingComponentTranslated)).withStyle(style -> style.withColor(textColor)));
    }

    @NotNull
    public Component getName(ItemStack stack) {
        StringBuilder nameBuilder = new StringBuilder(super.getName(stack).getString());
        TextColor textColor = this.color != DyeColor.BLACK ? TextColor.fromRgb((int)ColorMap.getColorValue(this.color)) : TextColor.fromRgb((int)0x3C3C3C);
        return Component.literal((String)nameBuilder.toString()).withStyle(style -> style.withColor(textColor));
    }
}

