/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.CoreStartupConfig;
import com.benbenlaw.core.util.CoreTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="bblcore")
public class ClimbableBlockEvent {
    @SubscribeEvent
    public static void onPlayerTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        boolean isTouchingClimbable = false;
        BlockPos entityPos = entity.blockPosition();
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos adjacentPos = entityPos.relative(direction);
            BlockState blockState = level.getBlockState(adjacentPos);
            if (!blockState.is(CoreTags.Blocks.CLIMBABLE_BLOCKS) || !blockState.isFaceSturdy((BlockGetter)level, adjacentPos, direction.getOpposite())) continue;
            isTouchingClimbable = true;
            break;
        }
        Vec3 movement = entity.getDeltaMovement();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.horizontalCollision && isTouchingClimbable) {
                if (!player.isShiftKeyDown()) {
                    Vec3 climbVec = new Vec3(movement.x, ((Double)CoreStartupConfig.climbableBlockSpeed.get()).doubleValue(), movement.z);
                    entity.setDeltaMovement(climbVec.scale(0.96));
                } else {
                    entity.setDeltaMovement(new Vec3(movement.x, 0.0, movement.z));
                }
            } else if (isTouchingClimbable && movement.y < 0.0) {
                if (!player.isShiftKeyDown()) {
                    Vec3 slowFallVec = new Vec3(movement.x, -((Double)CoreStartupConfig.climbableBlockSpeed.get()).doubleValue(), movement.z);
                    entity.setDeltaMovement(slowFallVec);
                    entity.resetFallDistance();
                } else {
                    entity.setDeltaMovement(new Vec3(movement.x, 0.0, movement.z));
                    entity.resetFallDistance();
                }
            }
        }
    }
}

