/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.colored.util;

import com.benbenlaw.core.block.colored.util.BlockTypeColorFinder;
import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.util.CoreTags;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public interface IColored {
    default public int getColor(int index) {
        return -1;
    }

    default public int getColor(int index, ItemStack stack) {
        return this.getColor(index);
    }

    public static class ItemColors
    implements ItemColor {
        public int getColor(ItemStack stack, int index) {
            DyeColor dyeColor;
            for (String colorTag : CoreTags.Blocks.COLOR_TAGS.keySet()) {
                if (!stack.is(CoreTags.Items.COLOR_TAGS.get(colorTag))) continue;
                DyeColor dyeColor2 = DyeColor.valueOf((String)colorTag.toUpperCase());
                int colorValue = ColorMap.getColorValue(dyeColor2);
                int alpha = 255;
                return alpha << 24 | colorValue & 0xFFFFFF;
            }
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            if (colorString != null && (dyeColor = ColorMap.getDyeColor(colorString)) != null) {
                int colorValue = ColorMap.getColorValue(dyeColor);
                int alpha = 255;
                return alpha << 24 | colorValue & 0xFFFFFF;
            }
            return index;
        }
    }

    public static class BlockColors
    implements BlockColor {
        public int getColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
            for (String colorTag : CoreTags.Blocks.COLOR_TAGS.keySet()) {
                if (!state.is(CoreTags.Blocks.COLOR_TAGS.get(colorTag))) continue;
                try {
                    DyeColor dyeColor = DyeColor.valueOf((String)colorTag.toUpperCase());
                    Integer colorValue = ColorMap.getColorValue(dyeColor);
                    if (colorValue == null) continue;
                    return colorValue;
                }
                catch (IllegalArgumentException dyeColor) {
                }
            }
            if (state.getBlock() instanceof IColored) {
                Integer colorValue;
                DyeColor dyeColor = null;
                Function<BlockState, DyeColor> colorRetriever = BlockTypeColorFinder.BLOCK_TYPE_COLOR_FINDER.get(state.getBlock().getClass());
                if (colorRetriever != null) {
                    dyeColor = colorRetriever.apply(state);
                }
                if (dyeColor != null && (colorValue = ColorMap.getColorValue(dyeColor)) != null) {
                    return colorValue;
                }
            }
            return tintIndex;
        }
    }
}

