/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block;

import com.benbenlaw.core.util.FakePlayerUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnbreakableResourceBlock
extends Block {
    public int dropHeightModifier;
    public Supplier<Item> toolToCollectTheBlockAsItem;
    public TagKey<Item> toolToCollectTheBlockAsTag;
    public String lootTable;
    public FakePlayer fakePlayer;

    public UnbreakableResourceBlock(BlockBehaviour.Properties properties, int dropHeightModifier, String toolToCollectTheBlock, String lootTable) {
        super(properties);
        this.dropHeightModifier = dropHeightModifier;
        this.lootTable = lootTable;
        if (toolToCollectTheBlock.startsWith("#")) {
            this.toolToCollectTheBlockAsTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)toolToCollectTheBlock.substring(1)));
        } else {
            this.toolToCollectTheBlockAsItem = () -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)toolToCollectTheBlock));
        }
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        BlockPos dropPos = new BlockPos(pos.getX(), pos.getY() + this.dropHeightModifier, pos.getZ());
        boolean isCorrectTool = false;
        if (this.toolToCollectTheBlockAsTag != null) {
            isCorrectTool = tool.is(this.toolToCollectTheBlockAsTag);
        }
        if (this.toolToCollectTheBlockAsItem != null) {
            boolean bl = isCorrectTool = tool.getItem() == this.toolToCollectTheBlockAsItem.get();
        }
        if (!isCorrectTool) {
            UnbreakableResourceBlock.dropResources((BlockState)state, (Level)level, (BlockPos)dropPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
            level.setBlockAndUpdate(pos, this.defaultBlockState());
        } else {
            UnbreakableResourceBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem(), 1));
        }
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ServerLevel level = params.getLevel();
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerUtil.createFakePlayer(level, "resource_block_fake_player");
        }
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.fakePlayer.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.fakePlayer).withParameter(LootContextParams.ORIGIN, (Object)this.fakePlayer.position()).create(LootContextParamSets.GIFT);
        LootTable table = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)this.lootTable)));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(List.of(ItemStack.EMPTY));
        ObjectArrayList loot = table.getRandomItems(lootparams);
        drops.addAll((Collection<ItemStack>)loot);
        return drops;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.toolToCollectTheBlockAsItem != null) {
            tooltipComponents.add((Component)Component.literal((String)this.toolToCollectTheBlockAsItem.get().toString()));
        }
        if (this.toolToCollectTheBlockAsTag != null) {
            tooltipComponents.add((Component)Component.literal((String)this.toolToCollectTheBlockAsTag.toString()));
        }
    }
}

