/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block;

import com.benbenlaw.core.block.UnbreakableResourceBlock;
import com.benbenlaw.core.block.brightable.BrightBlock;
import com.benbenlaw.core.item.TestItem;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TestBlock {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"bblcore");
    public static final DeferredBlock<Block> COLORED_BLOCK = TestBlock.registerBlock("colored_block", () -> new BrightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.STONE).instabreak().noOcclusion()));
    public static final DeferredBlock<Block> RESOURCE_BLOCK = TestBlock.registerBlock("resource_block", () -> new UnbreakableResourceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.STONE), 1, "minecraft:dirt", "minecraft:blocks/diamond_ore"));
    public static final DeferredBlock<Block> RESOURCE_BLOCK_2 = TestBlock.registerBlock("resource_block_2", () -> new UnbreakableResourceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.STONE), 1, "#minecraft:planks", "minecraft:blocks/emerald_ore"));

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return (DeferredBlock)BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = (DeferredBlock)BLOCKS.register(name, block);
        TestBlock.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        TestItem.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

