/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core;

import com.benbenlaw.core.block.TestBlock;
import com.benbenlaw.core.config.ColorTintIndexConfig;
import com.benbenlaw.core.config.CoreDefaultServerConfig;
import com.benbenlaw.core.config.CoreStartupConfig;
import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.item.CoreItems;
import com.benbenlaw.core.item.TestItem;
import com.benbenlaw.core.loot.condition.CoreLootModifierCondition;
import com.benbenlaw.core.loot.modifier.CoreLootModifiers;
import com.benbenlaw.core.recipe.CoreConditions;
import com.benbenlaw.core.recipe.CoreRecipes;
import com.benbenlaw.core.util.ColorHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;

@Mod(value="bblcore")
public class Core {
    public static final String MOD_ID = "bblcore";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Core(IEventBus eventBus, ModContainer modContainer) {
        TestItem.ITEMS.register(eventBus);
        TestBlock.BLOCKS.register(eventBus);
        CoreDataComponents.COMPONENTS.register(eventBus);
        CoreItems.ITEMS.register(eventBus);
        CoreRecipes.SERIALIZER.register(eventBus);
        CoreRecipes.TYPES.register(eventBus);
        CoreConditions.CONDITIONALS.register(eventBus);
        CoreLootModifierCondition.LOOT_CONDITION_TYPES.register(eventBus);
        CoreLootModifiers.LOOT_MODIFIER_SERIALIZERS.register(eventBus);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)ColorTintIndexConfig.SPEC, "bbl/core/color_index.toml");
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)CoreStartupConfig.SPEC, "bbl/core/startup.toml");
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)CoreDefaultServerConfig.SPEC, "bbl/core/default_server.toml");
        eventBus.addListener(this::addItemToCreativeTab);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.register((Object)new ColorHandler());
        }
    }

    private void addItemToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)CoreItems.UPGRADE_BASE.get());
        }
    }
}

