/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick.integration;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class COASCurios {
    private static final String MODID = "curios";
    private static final String SLOT_ID = "crafting_on_a_stick";

    public static void load() {
    }

    public static boolean hasMod() {
        return ModList.get().isLoaded(MODID);
    }

    public static Optional<IItemHandlerModifiable> getCuriosInventory(Player player) {
        if (COASCurios.hasMod()) {
            return Integrator.getCuriosInventory(player);
        }
        return Optional.empty();
    }

    private static final class Integrator {
        private Integrator() {
        }

        private static Optional<IItemHandlerModifiable> getCuriosInventory(Player player) {
            Optional itemHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
            if (itemHandler.isEmpty()) {
                return Optional.empty();
            }
            Optional stackHandler = ((ICuriosItemHandler)itemHandler.get()).getStacksHandler(COASCurios.SLOT_ID);
            return stackHandler.map(ICurioStacksHandler::getStacks);
        }
    }
}

