/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick;

import com.ofekn.crafting_on_a_stick.EntityContainerLevelAccess;
import com.ofekn.crafting_on_a_stick.MinecraftMenuBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemOnAStick
extends Item {
    private static final Item.Properties PROP = new Item.Properties().stacksTo(1);
    public final String registryPath;
    public final MenuProvider menuProvider;

    public ItemOnAStick(String registryPath, String containerName, MinecraftMenuBuilder builder) {
        super(PROP);
        this.registryPath = registryPath;
        this.menuProvider = new SimpleMenuProvider((id, inv, player) -> builder.create(id, inv, new EntityContainerLevelAccess((Entity)player)), (Component)Component.translatable((String)("container." + containerName)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.openMenu(this.menuProvider);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack), (Object[])new Object[]{Component.translatable((String)"gui.crafting_on_a_stick.prefix"), Component.translatable((String)("block.minecraft." + this.registryPath)), Component.translatable((String)"gui.crafting_on_a_stick.suffix")});
    }
}

