/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public interface IModuleNode
extends IElectricityNode {
    public static final AABB DEFAULT_NODE_BOX = new AABB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);

    @Override
    default public boolean isSourceNode() {
        return false;
    }

    @Override
    default public AABB getNodeInteractBox() {
        return DEFAULT_NODE_BOX;
    }

    default public void updateNodePoweredState() {
        if (((Boolean)Config.SERVER.electricity.cheats.everythingIsPowered.get()).booleanValue()) {
            if (!this.isNodePowered()) {
                this.setNodePowered(true);
            }
            return;
        }
        if (!this.isNodeReceivingPower()) {
            if (this.isNodePowered()) {
                this.setNodePowered(false);
            }
        } else if (!this.isNodePowered()) {
            this.setNodePowered(true);
        }
    }

    @Override
    default public void earlyNodeTick(Level level) {
        this.getPowerSources().clear();
    }

    default public void moduleTick(Level level) {
        if (!level.isClientSide) {
            this.updateNodePoweredState();
            this.setNodeReceivingPower(false);
        }
    }
}

