/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BathBlockEntity
extends BlockEntity
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BathBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.BATH.get(), pos, state);
    }

    public BathBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = this.createFluidContainer(state);
    }

    public boolean isHead() {
        return this.tank != null;
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank != null ? this.tank : this.getFluidContainerFromHead();
    }

    @Nullable
    private FluidContainer getFluidContainerFromHead() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)BathBlock.DIRECTION)) {
            Direction direction = (Direction)state.getValue((Property)BathBlock.DIRECTION);
            Level level = Objects.requireNonNull(this.level);
            BlockEntity blockEntity = level.getBlockEntity(this.worldPosition.relative(direction));
            if (blockEntity instanceof BathBlockEntity) {
                BathBlockEntity bath = (BathBlockEntity)blockEntity;
                return bath.getFluidContainer();
            }
        }
        return null;
    }

    @Nullable
    private FluidContainer createFluidContainer(BlockState state) {
        if (state.hasProperty(BathBlock.TYPE) && state.getValue(BathBlock.TYPE) == BathBlock.Type.HEAD) {
            return FluidContainer.create((Long)Config.SERVER.bath.fluidCapacity.get(), container -> {
                this.setChanged();
                container.sync(this);
            });
        }
        return null;
    }

    public ItemInteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        FluidContainer tank = this.getFluidContainer();
        if (tank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)Config.SERVER.bath.dispenseWater.get()).booleanValue() && player.getItemInHand(hand).isEmpty()) {
            Pair<Fluid, Long> drained;
            long filled;
            if ((tank.isEmpty() || tank.getStoredFluid().isSame((Fluid)Fluids.WATER)) && (filled = tank.push((Fluid)Fluids.WATER, FluidContainer.BUCKET_CAPACITY, false)) > 0L) {
                this.sendTapWaterAnimation();
                Objects.requireNonNull(this.level).playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), SoundSource.BLOCKS);
                return ItemInteractionResult.SUCCESS;
            }
            if (tank.getStoredAmount() >= FluidContainer.BUCKET_CAPACITY && tank.getStoredFluid().isSame((Fluid)Fluids.LAVA) && (Long)(drained = tank.pull(FluidContainer.BUCKET_CAPACITY, true)).right() == FluidContainer.BUCKET_CAPACITY) {
                tank.pull(FluidContainer.BUCKET_CAPACITY, false);
                Vec3 pos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add(0.0, 1.0, 0.0);
                Level level = Objects.requireNonNull(this.level);
                ItemEntity entity = new ItemEntity(level, pos.x, pos.y, pos.z, new ItemStack((ItemLike)Blocks.OBSIDIAN));
                entity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)entity);
                level.playSound(null, this.worldPosition, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS);
                level.levelEvent(1501, this.worldPosition, 0);
                this.sendTapWaterAnimation();
                return ItemInteractionResult.SUCCESS;
            }
        }
        return Services.FLUID.performInteractionWithBlock(player, hand, this.getLevel(), this.getBlockPos(), result.getDirection());
    }

    private void sendTapWaterAnimation() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)BathBlock.DIRECTION)) {
            BlockPos tapPos = this.isHead() ? this.worldPosition : this.worldPosition.relative((Direction)state.getValue((Property)BathBlock.DIRECTION));
            Network.getPlay().sendToTrackingBlockEntity(() -> this, (Object)new MessageWaterTapAnimation(tapPos));
        }
    }

    @Override
    public void playWaterAnimation() {
        if (this.isHead()) {
            this.animationTime = 4;
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BathBlockEntity bath) {
        if (bath.animationTime > 0) {
            Vec3 tap = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.relative((Direction)state.getValue((Property)BathBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.x + Utils.pixels(0.5) * level.random.nextGaussian();
                double z = tap.z + Utils.pixels(0.5) * level.random.nextGaussian();
                level.addParticle((ParticleOptions)ModParticleTypes.TAP_WATER.get(), x, tap.y, z, 0.0, 0.0, 0.0);
            }
            --bath.animationTime;
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (this.tank != null) {
            this.tank.load(tag.getCompound("FluidTank"), provider);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.tank != null) {
            CompoundTag tankTag = new CompoundTag();
            this.tank.save(tankTag, provider);
            tag.put("FluidTank", (Tag)tankTag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

