/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.xkmc.fruitsdelight.content.block.DoubleFruitBushBlock;
import dev.xkmc.fruitsdelight.content.block.FruitBushBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public enum FDBushType {
    CROSS,
    BLOCK,
    TALL;


    public BlockEntry<? extends BushBlock> build(String name, FDBushes bush) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> FruitsDelight.REGISTRATE.block(name, p -> new FruitBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH), bush::getFruit, this)).blockstate((ctx, pvd) -> pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int age = (Integer)state.getValue((Property)FruitBushBlock.AGE);
                Object id = ctx.getName();
                if (age == 1) {
                    return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)id + "_0"))).build();
                }
                id = (String)id + "_" + (age == 0 ? 0 : age - 1);
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)pvd.models().cross((String)id, pvd.modLoc("block/" + (String)id))).renderType("cutout");
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            })).loot(bush::buildLoot).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT}).register();
            case 1 -> ((BlockBuilder)FruitsDelight.REGISTRATE.block(name, p -> new FruitBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZALEA), bush::getFruit, this)).blockstate((ctx, pvd) -> pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int age = (Integer)state.getValue((Property)FruitBushBlock.AGE);
                Object id = ctx.getName();
                Object parent = "bush";
                if (age == 0) {
                    id = (String)id + "_small";
                    parent = (String)parent + "_small";
                }
                if (age == 1) {
                    return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)id + "_small"))).build();
                }
                if (age == 3) {
                    id = (String)id + "_flowers";
                }
                if (age == 4) {
                    id = (String)id + "_fruits";
                }
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder((String)id)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)parent)));
                model.texture("face", "block/" + (String)id + "_face");
                model.texture("cross", "block/" + (String)id + "_cross");
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            })).loot(bush::buildLoot).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE, BlockTags.SWORD_EFFICIENT}).item().build()).register();
            case 2 -> ((BlockBuilder)FruitsDelight.REGISTRATE.block(name, p -> new DoubleFruitBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AZALEA), bush::getFruit, this)).blockstate((ctx, pvd) -> pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int age = (Integer)state.getValue((Property)FruitBushBlock.AGE);
                Object modelId = ctx.getName();
                Object parent = "tall_bush";
                String trunk = age <= 1 ? "_small_trunk" : "_trunk";
                Object tex = "";
                if (age == 0) {
                    modelId = (String)modelId + "_small";
                    parent = (String)parent + "_small";
                }
                if (age == 1) {
                    modelId = (String)modelId + "_mid";
                    parent = (String)parent + "_mid";
                }
                if (age == 3) {
                    tex = "_flowers";
                }
                if (age == 4) {
                    tex = "_fruits";
                }
                modelId = (String)modelId + (String)tex;
                tex = ctx.getName() + (String)tex;
                if (state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                    return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().cubeColumn((String)modelId + "_upper", pvd.modLoc("block/" + (String)tex + "_upper"), pvd.modLoc("block/" + (String)tex + "_top"))).texture("particle", pvd.modLoc("block/" + (String)tex + "_upper"))).build();
                }
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder((String)modelId)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)parent)));
                model.texture("upper", "block/" + (String)tex + "_upper");
                model.texture("lower", "block/" + (String)tex + "_lower");
                model.texture("trunk", "block/" + ctx.getName() + trunk);
                model.texture("top", "block/" + (String)tex + "_top");
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            })).loot(bush::buildLoot).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE, BlockTags.SWORD_EFFICIENT}).item().model((ctx, pvd) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder("item/" + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/tall_bush_item")))).texture("upper", "block/" + ctx.getName() + "_upper")).texture("lower", "block/" + ctx.getName() + "_lower")).texture("trunk", "block/" + ctx.getName() + "_trunk")).texture("top", "block/" + ctx.getName() + "_top")).build()).register();
        };
    }
}

